/**
  ******************************************************************************
  * @file    main.c
  * @author  Ac6
  * @version V1.0
  * @date    01-December-2013
  * @brief   Default main function.
  ******************************************************************************
*/

#include <stdlib.h>
#include "stm32f4xx.h"
#include "stm32f4xx_hal.h"
#include "stm32f4xx_hal_uart.h"
#include "stm32f429i_discovery.h"
#include "stm32f429i_discovery_lcd.h"
#include "system_clocks.h"
#include "simpleLCD.h"
#include "random.h"
#include "serial.h"

/* Private typedef -----------------------------------------------------------*/

/* Exported macro ------------------------------------------------------------*/

/* Private macro -----------------------
 * --------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* UART handler declaration */
UART_HandleTypeDef UartHandle;

static char str[20];

/* Private function prototypes -----------------------------------------------*/
static void EXTILine0_Config(void);

/* Private functions ---------------------------------------------------------*/

int main(void){

  int16_t zn = '\0';
  HAL_Init();

  /* Configure LED3 and LED4 */
  BSP_LED_Init(LED3);
  BSP_LED_Init(LED4);

  /* Configure the system clock to 180 MHz */
  SystemClock_Config();

  /* Configure EXTI Line0 (connected to PA0 pin) in interrupt mode */
  EXTILine0_Config();
  Serial_Init();
  RNG_Init();
  LCD_Init();
  LCD_SetFont(FONT16);
  LCD_PrintXY(6,1,"Witam !");
  BSP_LED_Off(LED3);
  BSP_LED_On(LED4);

  LCD_PrintXY(0,3,"Wpisz na terminalu: L");
  LCD_PrintXY(0,5,"Transmisja: 9600 8N1");

  /* Infinite loop */
  while(1){
    BSP_LED_Toggle(LED3); //czyli PG13
    BSP_LED_Toggle(LED4);

    HAL_Delay(200);//
    if( (zn=Serial_GetKey()) != Serial_Error ){
    	sprintf(str,"Wpisano: %c kod:0x%X  ",zn, zn);
    	LCD_PrintXY(1,10,str);
    	if( zn == 'l' || zn=='L'){
    		BSP_LED_Toggle(LED4);
    		Serial_Send((uint8_t*)"Zmiana LED4\n", 12);
    	}
    }
	Serial_Send((uint8_t*)"Test UART\n", 10);
  }
}

/**
  * @brief  Configures EXTI Line0 (connected to PA0 pin) in interrupt mode
  * @param  None
  * @retval None
  */
static void EXTILine0_Config(void)
{
  GPIO_InitTypeDef   GPIO_InitStructure;

  /* Enable GPIOA clock */
  __HAL_RCC_GPIOA_CLK_ENABLE();

  /* Configure PA0 pin as input floating */
  GPIO_InitStructure.Mode = GPIO_MODE_IT_FALLING;
  GPIO_InitStructure.Pull = GPIO_NOPULL;
  GPIO_InitStructure.Pin = GPIO_PIN_0;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStructure);

  /* Enable and set EXTI Line0 Interrupt to the lowest priority */
  HAL_NVIC_SetPriority(EXTI0_IRQn, 2, 0);
  HAL_NVIC_EnableIRQ(EXTI0_IRQn);
}

/**
  * @brief EXTI line detection callbacks
  * @param GPIO_Pin: Specifies the pins connected EXTI line
  * @retval None
  */
void HAL_GPIO_EXTI_Callback(uint16_t GPIO_Pin)
{
  if(GPIO_Pin == KEY_BUTTON_PIN)
  {
    //*** TU wpisz reakcję na przycisk
    // np.
    /* Toggle LED3 */
    //BSP_LED_Toggle(LED3);
	//startTime = HAL_GetTick();
  }
}

/*
void HAL_SYSTICK_Callback(void)
{
  // tu wpisz obsługę SysTick
  // czyli co ma byc wykonywane co 1[ms]

}

*/

