/**
 * Class ChartWindow, IntermediateValuesWindow, ClickOKListener, CSVWriter for MedCalApp.java
 * 
 * @author Dawid Worek
 * @version 6.0
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.io.*;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

import org.jfree.chart.*;
import com.csvreader.*;
import java.text.*;
import java.awt.Toolkit; 

/**
 * Class to show window with chart.
 * @author Dawid Worek (BunnySoft)
 *
 */
class ChartWindow {
	//Okno
	private JFrame f;
	
	/**
	 * Show window with chart
	 * @param chart
	 */
	public ChartWindow(JFreeChart chart) {
		
		//Godzina ktora bedzie wpisana do tytulu
		GregorianCalendar time = new GregorianCalendar ();
		
		f = new JFrame ();
		f.setSize(800, 600);
		f.setVisible(true);
		f.setTitle(
				"Chart [" +
				time.get(Calendar.HOUR_OF_DAY) + ":" + time.get(Calendar.MINUTE) + ":" + 
				time.get(Calendar.SECOND) + "]");

		//Button 'Close'
		JPanel closeButton = new JPanel ();
		
		//Przycisk do zamkniecia
		JButton close = new JButton("Close");
		closeButton.add(close);
		
		f.add(closeButton, BorderLayout.SOUTH);
		
		close.addActionListener(new ActionListener ()
		{
			public void actionPerformed (ActionEvent event)
			{
				f.setVisible(false);
			}
		});
		
		ChartPanel panelChart = new ChartPanel(chart);
		
		f.getContentPane().add(panelChart);
	}
}

/**
 * Class to show intermediate values (matrix and vectors).
 * @author Dawid Worek
 *
 */
class IntermediateValuesWindow extends JFrame
{
	
	private boolean sourceOfVectorC2 = true;
	
	//Format number to show
	private NumberFormat nf = NumberFormat.getInstance(Locale.US);
	
	//Matrix
	private double[][] mB1 = new double[4][4];
	private double[][] mB2 = new double[4][4];
	private double[] C = new double[4];
	private double[] C2 = new double[4];
	private double[] R = new double[4];
	private double[] G = new double[4];
	
	//Action
	private ClickOKListener listener = null;
	
	//TextFields with values of vectors and matrix
	private JTextField[] values = new JTextField[48];
	private int iter = 0;
	
	/**
	 * Constructor.
	 * @param matrixB1
	 * @param matrixB2
	 * @param c
	 * @param c2
	 * @param r
	 * @param g
	 * @param lambda1
	 * @param lambda2
	 */
	
	public IntermediateValuesWindow(double[][] matrixB1, double[][] matrixB2, double[] c, double[] c2, double[] r, double[] g, double[] lambda1, double[] lambda2)
	{
		for (int i = 0; i <matrixB1.length; i++) {
			System.arraycopy(matrixB1[i], 0, mB1[i], 0, matrixB1.length);
			System.arraycopy(matrixB2[i], 0, mB2[i], 0, matrixB2.length);
		}
		
		System.arraycopy(c, 0, C, 0, c.length);
		System.arraycopy(c2, 0, C2, 0, c2.length);
		System.arraycopy(r, 0, R, 0, r.length);
		System.arraycopy(g, 0, G, 0, g.length);
		
		nf.setMaximumFractionDigits(6);
		nf.setMinimumFractionDigits(1);
		
		Toolkit tk = Toolkit.getDefaultToolkit();  
		int xSize = ((int) tk.getScreenSize().getWidth());  
		int ySize = ((int) tk.getScreenSize().getHeight());
		setTitle("Intermediate values");
		setLayout(new GridLayout(2, 3));
		setSize(xSize, ySize);
		
		add(createPanel(matrixB1, "Matrix B for phase 1"));
		add(createPanel(matrixB2, "Matrix B for phase 2"));
		
		add(createPanel(c, "Vector C for phase 1"));
		add(createPanel(c2, "Vector C for phase 2"));
		add(createPanel(r, "Vector R"));
		add(createPanel(g, "Vector G"));
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener () {
			public void actionPerformed (ActionEvent event)
			{	
				
				if (listener != null) {
					
					mB1[0][0] = Double.parseDouble(values[0].getText());
					mB1[0][1] = Double.parseDouble(values[1].getText());
					mB1[0][2] = Double.parseDouble(values[2].getText());
					mB1[0][3] = Double.parseDouble(values[3].getText());
					mB1[1][0] = Double.parseDouble(values[4].getText());
					mB1[1][1] = Double.parseDouble(values[5].getText());
					mB1[1][2] = Double.parseDouble(values[6].getText());
					mB1[1][3] = Double.parseDouble(values[7].getText());
					mB1[2][0] = Double.parseDouble(values[8].getText());
					mB1[2][1] = Double.parseDouble(values[9].getText());
					mB1[2][2] = Double.parseDouble(values[10].getText());
					mB1[2][3] = Double.parseDouble(values[11].getText());
					mB1[3][0] = Double.parseDouble(values[12].getText());
					mB1[3][1] = Double.parseDouble(values[13].getText());
					mB1[3][2] = Double.parseDouble(values[14].getText());
					mB1[3][3] = Double.parseDouble(values[15].getText());
					
					mB2[0][0] = Double.parseDouble(values[16].getText());
					mB2[0][1] = Double.parseDouble(values[17].getText());
					mB2[0][2] = Double.parseDouble(values[18].getText());
					mB2[0][3] = Double.parseDouble(values[19].getText());
					mB2[1][0] = Double.parseDouble(values[20].getText());
					mB2[1][1] = Double.parseDouble(values[21].getText());
					mB2[1][2] = Double.parseDouble(values[22].getText());
					mB2[1][3] = Double.parseDouble(values[23].getText());
					mB2[2][0] = Double.parseDouble(values[24].getText());
					mB2[2][1] = Double.parseDouble(values[25].getText());
					mB2[2][2] = Double.parseDouble(values[26].getText());
					mB2[2][3] = Double.parseDouble(values[27].getText());
					mB2[3][0] = Double.parseDouble(values[28].getText());
					mB2[3][1] = Double.parseDouble(values[29].getText());
					mB2[3][2] = Double.parseDouble(values[30].getText());
					mB2[3][3] = Double.parseDouble(values[31].getText());
					
					C[0] = Double.parseDouble(values[32].getText());
					C[1] = Double.parseDouble(values[33].getText());
					C[2] = Double.parseDouble(values[34].getText());
					C[3] = Double.parseDouble(values[35].getText());
					
					C2[0] = Double.parseDouble(values[36].getText());
					C2[1] = Double.parseDouble(values[37].getText());
					C2[2] = Double.parseDouble(values[38].getText());
					C2[3] = Double.parseDouble(values[39].getText());
					
					R[0] = Double.parseDouble(values[40].getText());
					R[1] = Double.parseDouble(values[41].getText());
					R[2] = Double.parseDouble(values[42].getText());
					R[3] = Double.parseDouble(values[43].getText());
					
					G[0] = Double.parseDouble(values[44].getText());
					G[1] = Double.parseDouble(values[45].getText());
					G[2] = Double.parseDouble(values[46].getText());
					G[3] = Double.parseDouble(values[47].getText());
					
					listener.click(mB1, mB2, C, C2, R, G);
				}
			}
		});
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new ActionListener () {
			public void actionPerformed (ActionEvent event)
			{
				setVisible(false);
			}
		});
		
		JLabel text = new JLabel("Numbers are rounded to 6 decimal places");
		JLabel text2 = new JLabel("<html>If you click Ok, program hides <br>chart window and runs again <br>with new values</html>");
		
		JPanel okB = new JPanel();
		okB.add(okButton);
		okB.add(cancel);
		okB.add(text);
		okB.add(text2);
		
		Border ethed = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(ethed, "Source of vector C phase 2");
		JPanel radioButton = new JPanel ();
		radioButton.setBorder(titled);
		radioButton.setLayout(new GridLayout(1,2));
		ButtonGroup opt = new ButtonGroup ();
		JRadioButton phase1 = new JRadioButton("<html>Values from <br>end of phase 1<html>", true);
		opt.add(phase1);
		radioButton.add(phase1);
		JRadioButton fromTextFields = new JRadioButton("<html>Values from <br>text fields</html>", false);
		opt.add(fromTextFields);
		radioButton.add(fromTextFields);
		okB.add(radioButton);
		
		ActionListener for_phase1 = new ActionListener () {
			public void actionPerformed(ActionEvent event) {
				sourceOfVectorC2 = true;
			}
		};
		phase1.addActionListener(for_phase1);
		
		ActionListener for_fromTextFields = new ActionListener () {
			public void actionPerformed(ActionEvent event) {
				sourceOfVectorC2 = false;
			}
		};
		fromTextFields.addActionListener(for_fromTextFields);
		
		JPanel eigenvalues = new JPanel();
		eigenvalues.setLayout(new GridLayout(2, 1));
		
		JPanel eigenvalueDecomposition = new JPanel ();
		Border ethed1 = BorderFactory.createEtchedBorder();
		Border titled1 = BorderFactory.createTitledBorder(ethed, "Eigenvalue (lambda) for phase 1");
		eigenvalueDecomposition.setBorder(titled1);
		JLabel lab = new JLabel(
				"<html>" +
				Double.toString(lambda1[0]) + "<br><br>" +
				Double.toString(lambda1[1]) + "<br><br>" +
				Double.toString(lambda1[2]) + "<br><br>" +
				Double.toString(lambda1[3])
				);
		eigenvalueDecomposition.add(lab);
		eigenvalues.add(eigenvalueDecomposition);
		
		JPanel eigenvalue2Decomposition = new JPanel ();
		Border ethed2 = BorderFactory.createEtchedBorder();
		Border titled2 = BorderFactory.createTitledBorder(ethed, "Eigenvalue (lambda) for phase 2");
		eigenvalue2Decomposition.setBorder(titled2);
		JLabel lab2 = new JLabel(
				"<html>" +
				Double.toString(lambda2[0]) + "<br><br>" +
				Double.toString(lambda2[1]) + "<br><br>" +
				Double.toString(lambda2[2]) + "<br><br>" +
				Double.toString(lambda2[3])
				);
		eigenvalue2Decomposition.add(lab2);
		eigenvalues.add(eigenvalue2Decomposition);
		
		add(eigenvalues);
		add( okB, BorderLayout.SOUTH);
	}

	/**
	 * Run action when user click 'Ok' button.
	 * @param ClickOKListener listener
	 */
	public void addClickOKListener(ClickOKListener l)
	{
		listener = l;
	}
	
	/**
	 * Set values of vector C for phase 2.
	 * @param newValues
	 */
	public void setValuesOfVectorC2(double[] newValues) 
	{
		values[36].setText(Double.toString(newValues[0]));
		values[37].setText(Double.toString(newValues[1]));
		values[38].setText(Double.toString(newValues[2]));
		values[39].setText(Double.toString(newValues[3]));
	}
	
	/**
	 * Create a panel with border for matrix.
	 * @param matrix
	 * @param title
	 * @return panel
	 */
	private JPanel createPanel(double[][] matrix, String title)
	{
		JPanel matrixPanel = new JPanel ();
		matrixPanel.setLayout( new GridLayout(4,4));
		
		//Border
		Border ethed = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(ethed, title);
		matrixPanel.setBorder(titled);
		
		for (int i = 0; i<4; i++) {
			for (int j = 0; j<4; j++) {
				values[iter] = new JTextField( nf.format( matrix[i][j]) );
				values[iter].setHorizontalAlignment(JTextField.CENTER);
				matrixPanel.add( values[iter] );
				++iter;
			}
		}
		
		return matrixPanel;
	}
	
	/**
	 * Create panel with border for vector.
	 * @param vector
	 * @param title
	 * @return panel
	 */
	private JPanel createPanel(double[] vector, String title)
	{
		JPanel matrixPanel = new JPanel ();
		matrixPanel.setLayout( new GridLayout(4, 1));
		
		//Border
		Border ethed = BorderFactory.createEtchedBorder();
		Border titled = BorderFactory.createTitledBorder(ethed, title);
		matrixPanel.setBorder(titled);
		
		for (int i = 0; i<4; i++) {
			values[iter] = new JTextField( nf.format( vector[i] ) );
			values[iter].setHorizontalAlignment(JTextField.CENTER);
			matrixPanel.add( values[iter] );
			++iter;
		}

		return matrixPanel;
	}
	
	/**
	 * Get source of values for vector C phase 2
	 * True - end of phase 1 
	 * False - values from text  fields
	 * @return boolean
	 */
	public boolean getSourceOfVectorC2( ) {
		return sourceOfVectorC2;
	}
}

/**
 * Interface to support click button 'OK' in IntermediateValuesWindow
 * @author Dawid Worek
 *
 */
interface ClickOKListener {
	
	void click(double[][] matrixB1, double[][] matrixB2, double[] c, double[] c2, double[] r, double[] g);
	
}

/**
 * Class to create csv file.
 * @author Dawid Worek
 *
 */
class CSVWriter
{
	private CsvWriter out;
	
	/**
	 * Create a file
	 * @param filename
	 * @throws IOException
	 */
	public CSVWriter(String filename) throws IOException
	{
		out = new CsvWriter(filename);
		out.setDelimiter(';');
		out.setForceQualifier(true);
	}
	
	/**
	 * Write data to file
	 * @param data
	 */
	public void write(String[] data)
	{	
		try {
			for (int i = 0; i < data.length; i++) {
				out.write(data[i]);
			}
			out.endRecord();
		}
		catch (IOException e) {
			return;
		}
		
	}
	
	/**
	 * Stop write to file
	 */
	public void close ()
	{
		out.close ();
	}
}