/**
 * Main file in project.
 * 
 * @author Dawid Worek
 * @version 6.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.filechooser.*;

import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.io.*;

import Jama.*;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeriesCollection;

/**
* @version 6.1
* @author Dawid Worek
*/
public class MedCalApp extends JApplet
{
	public void init ()
	{	
		EventQueue.invokeLater(new Runnable () {
			public void run () {
				//INTERFACE UZYTKOWNIKA
				
				setLayout(new GridLayout(2,3));
				
				//Obramowanie 'Time' ze zmienymi t
				Border ethed = BorderFactory.createEtchedBorder();
				Border titled = BorderFactory.createTitledBorder(ethed, "Time");
				
				JPanel mainTimePanel = new JPanel ();
				
				mainTimePanel.setLayout(new GridLayout(8, 1, 0, 0));
				
				JPanel timed = new JPanel ();
				timed.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel dt_d = new JLabel("t_d = ");
				dt_d.setHorizontalAlignment(JLabel.RIGHT);
				t_d = new JTextField("250",5);
				t_d.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_td = new JLabel("<html>treatment<br>duration in min</html>") ;
				timed.add(dt_d);
				timed.add(t_d);
				timed.add(des_td);
				
				mainTimePanel.add(timed);
				
				JPanel timedi = new JPanel ();
				timedi.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel dt_di = new JLabel("t_di = ");
				dt_di.setHorizontalAlignment(JLabel.RIGHT);
				t_di = new JTextField("2880",6);
				t_di.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_tdi = new JLabel("<html>time of the<br>whole cycle in min</html>") ;
				timedi.add(dt_di);
				timedi.add(t_di);
				timedi.add(des_tdi);
				
				mainTimePanel.add(timedi);
				
				mainTimePanel.setBorder(titled);
				
				add(mainTimePanel);
				
				//Model Parametr
				Border ethed1 = BorderFactory.createEtchedBorder();
				Border titled1 = BorderFactory.createTitledBorder(ethed1, "Model Parametrs");
				
				JPanel mainParPanel = new JPanel ();
				
				mainParPanel.setLayout(new GridLayout(9, 1, 0, 0));
				
				//Qc
				JPanel qc = new JPanel ();
				qc.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel qc_d = new JLabel("Qc = ");
				qc_d.setHorizontalAlignment(JLabel.RIGHT);
				Qc = new JTextField("5.8",5);
				Qc.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_qc = new JLabel("<html>cardiac output<br>in L/min</html>");
				qc.add(qc_d);
				qc.add(Qc);
				qc.add(des_qc);
				
				mainParPanel.add(qc);
				
				//Qf
				JPanel qf = new JPanel ();
				qf.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel qf_d = new JLabel("Qf = ");
				qf_d.setHorizontalAlignment(JLabel.RIGHT);
				Qf = new JTextField("1",5);
				Qf.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_qf = new JLabel("<html>fistula flow<br>in L/min</html>");
				qf.add(qf_d);
				qf.add(Qf);
				qf.add(des_qf);
				
				mainParPanel.add(qf);
				
				//Vx
				JPanel vx = new JPanel ();
				vx.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel vx_d = new JLabel("Vx = ");
				vx_d.setHorizontalAlignment(JLabel.RIGHT);
				Vx = new JTextField("0.25",5);
				Vx.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_vx = new JLabel("<html>extracorporeal<br>blood volume in L<html>");
				vx.add(vx_d);
				vx.add(Vx);
				vx.add(des_vx);
				
				mainParPanel.add(vx);
				
				//Vb
				JPanel vb = new JPanel ();
				vb.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel vb_d = new JLabel("Vb = ");
				vb_d.setHorizontalAlignment(JLabel.RIGHT);
				Vb = new JTextField("5.9",5);
				Vb.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_vb = new JLabel("<html>blood volume<br>in L</html>");
				vb.add(vb_d);
				vb.add(Vb);
				vb.add(des_vb);
				
				mainParPanel.add(vb);
				
				//fp
				JPanel fp_p = new JPanel ();
				fp_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel fp_d = new JLabel("fp = ");
				fp_d.setHorizontalAlignment(JLabel.RIGHT);
				fp = new JTextField("0.96",5);
				fp.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_fp = new JLabel("<html>fraction of<br>packed cell volume</html>");
				fp_p.add(fp_d);
				fp_p.add(fp);
				fp_p.add(des_fp);
				
				mainParPanel.add(fp_p);
				
				//fpw
				JPanel fpw_p = new JPanel ();
				fpw_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel fpw_d = new JLabel("fpw = ");
				fpw_d.setHorizontalAlignment(JLabel.RIGHT);
				fpw = new JTextField("0.93",5);
				fpw.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_fpw = new JLabel("<html>fraction of<br>plasma water</html>");
				fpw_p.add(fpw_d);
				fpw_p.add(fpw);
				fpw_p.add(des_fpw);
				
				mainParPanel.add(fpw_p);
				
				
				//fQH
				JPanel fQH_p = new JPanel ();
				fQH_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel fQH_d = new JLabel("fQH = ");
				fQH_d.setHorizontalAlignment(JLabel.RIGHT);
				fQH = new JTextField("0.85",5);
				fQH.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_fQH = new JLabel("<html>fraction of<br>high flow blood flow</html>");
				fQH_p.add(fQH_d);
				fQH_p.add(fQH);
				fQH_p.add(des_fQH);
				
				mainParPanel.add(fQH_p);
				
				//fVH
				JPanel fVH_p = new JPanel ();
				fVH_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel fVH_d = new JLabel("fVH = ");
				fVH_d.setHorizontalAlignment(JLabel.RIGHT);
				fVH = new JTextField("0.2",5);
				fVH.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_fVH = new JLabel("<html>fraction of<br>high flow volume</html>");
				fVH_p.add(fVH_d);
				fVH_p.add(fVH);
				fVH_p.add(des_fVH);
				
				mainParPanel.add(fVH_p);
				
				//fecv
				JPanel fecv_p = new JPanel ();
				fecv_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel fecv_d = new JLabel("fecv = ");
				fecv_d.setHorizontalAlignment(JLabel.RIGHT);
				fecv = new JTextField("0.33",5);
				fecv.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_fecv = new JLabel("<html>fraction of<br>extracellular volume</html>");
				fecv_p.add(fecv_d);
				fecv_p.add(fecv);
				fecv_p.add(des_fecv);
				
				mainParPanel.add(fecv_p);
				
				mainParPanel.setBorder(titled1);
				
				add(mainParPanel);
				
				//mainSettings
				Border ethed2 = BorderFactory.createEtchedBorder();
				Border titled2 = BorderFactory.createTitledBorder(ethed2, "Patient and dialysis settings");
				
				JPanel mainSettings = new JPanel ();
				
				mainSettings.setLayout(new GridLayout(7, 1, 0, 0));
				
				//Vt0
				JPanel Vt0_p = new JPanel ();
				Vt0_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel Vt0_d = new JLabel("Vtd = ");
				Vt0_d.setHorizontalAlignment(JLabel.RIGHT);
				Vt0 = new JTextField("28.6",5);
				Vt0.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_Vt0 = new JLabel("<html> total distri-<br>bution volume at t=0 in L</html>");
				Vt0_p.add(Vt0_d);
				Vt0_p.add(Vt0);
				Vt0_p.add(des_Vt0);
				
				mainSettings.add(Vt0_p);
				
				//Vuf
				JPanel Vuf_p = new JPanel ();
				Vuf_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel Vuf_d = new JLabel("Vuf = ");
				Vuf_d.setHorizontalAlignment(JLabel.RIGHT);
				Vuf = new JTextField("3.46",5);
				Vuf.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_Vuf = new JLabel("<html>ultrafiltration<br>volume in L</html>");
				Vuf_p.add(Vuf_d);
				Vuf_p.add(Vuf);
				Vuf_p.add(des_Vuf);
				
				mainSettings.add(Vuf_p);
				
				//H
				JPanel H_p = new JPanel ();
				H_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel H_d = new JLabel("H = ");
				H_d.setHorizontalAlignment(JLabel.RIGHT);
				H = new JTextField("0.37",5);
				H.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_H = new JLabel("<html>hematocrit fra-<br>ction</html>");
				H_p.add(H_d);
				H_p.add(H);
				H_p.add(des_H);
				
				mainSettings.add(H_p);
				
				//Qx
				JPanel Qx_p = new JPanel ();
				Qx_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel Qx_d = new JLabel("Qx = ");
				Qx_d.setHorizontalAlignment(JLabel.RIGHT);
				Qx = new JTextField("0.327",5);
				Qx.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_Qx = new JLabel("<html>extracorporeal<br>blood flow in L/min</html>");
				Qx_p.add(Qx_d);
				Qx_p.add(Qx);
				Qx_p.add(des_Qx);
				
				mainSettings.add(Qx_p);
				
				//Ex
				JPanel Ex_p = new JPanel ();
				Ex_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel Ex_d = new JLabel("Ex = ");
				Ex_d.setHorizontalAlignment(JLabel.RIGHT);
				Ex = new JTextField("0.8",5);
				Ex.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_Ex = new JLabel("<html>fraction of<br>dialyzer extraction<html>");
				Ex_p.add(Ex_d);
				Ex_p.add(Ex);
				Ex_p.add(des_Ex);
				
				mainSettings.add(Ex_p);
				
				mainSettings.setBorder(titled2);
				
				add(mainSettings);
				
				//Solute parameters
				Border ethed3 = BorderFactory.createEtchedBorder();
				Border titled3 = BorderFactory.createTitledBorder(ethed3, "Solute parameters");
			
				JPanel solutePar = new JPanel ();
				solutePar.setLayout(new GridLayout(7, 1, 0, 0));
				
				//przelaczniki
				JPanel radioButton = new JPanel ();
				radioButton.setLayout(new GridLayout(1,2));
				ButtonGroup opt = new ButtonGroup ();
				JRadioButton urea = new JRadioButton("Urea", false);
				opt.add(urea);
				radioButton.add(urea);
				JRadioButton creatinine = new JRadioButton("Creatinine", true);
				opt.add(creatinine);
				radioButton.add(creatinine);
				
				solutePar.add(radioButton);
				
				//Ct0
				JPanel Ct0_p = new JPanel ();
				Ct0_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel Ct0_d = new JLabel("Ct0 = ");
				Ct0_d.setHorizontalAlignment(JLabel.RIGHT);
				Ct0 = new JTextField("0.11",5);
				Ct0.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_Ct0 = new JLabel("<html>concentration<br>at t=0 in g/L</html>");
				Ct0_p.add(Ct0_d);
				Ct0_p.add(Ct0);
				Ct0_p.add(des_Ct0);
				
				solutePar.add(Ct0_p);
				
				//G24
				JPanel G24_p = new JPanel ();
				G24_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel G24_d = new JLabel("G24 = ");
				G24_d.setHorizontalAlignment(JLabel.RIGHT);
				G24 = new JTextField("0.00983",5);
				G24.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_G24 = new JLabel("<html>generation<br>rate in mol/24h</html>");
				G24_p.add(G24_d);
				G24_p.add(G24);
				G24_p.add(des_G24);
				
				solutePar.add(G24_p);
				
				//ks
				JPanel ks_p = new JPanel ();
				ks_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel ks_d = new JLabel("ks = ");
				ks_d.setHorizontalAlignment(JLabel.RIGHT);
				ks = new JTextField("0.022",5);
				ks.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_ks = new JLabel("<html>specific rate<br>constant in 1/min</html>");
				ks_p.add(ks_d);
				ks_p.add(ks);
				ks_p.add(des_ks);
				
				solutePar.add(ks_p);
				
				//few
				JPanel few_p = new JPanel ();
				few_p.setLayout(new GridLayout(1, 3, 0, 0));
				JLabel few_d = new JLabel("few = ");
				few_d.setHorizontalAlignment(JLabel.RIGHT);
				few = new JTextField("0.72",5);
				few.setHorizontalAlignment(JTextField.CENTER);
				JLabel des_few = new JLabel("<html>erythrocyte water<br>fraction</html>");
				few_p.add(few_d);
				few_p.add(few);
				few_p.add(des_few);
				
				solutePar.add(few_p);
				
				//Akcje dla przelacznikow
				ActionListener for_urea = new ActionListener ()
				{
					public void actionPerformed(ActionEvent event)
					{
						Ct0.setText("1.47");
						G24.setText("0.31");
						ks.setText("158.000");
						urea_crea = true;
					}
				};
				urea.addActionListener(for_urea);
				
				ActionListener for_crea = new ActionListener ()
				{
					public void actionPerformed(ActionEvent event)
					{
						Ct0.setText("0.11");
						G24.setText("0.00983");
						ks.setText("0.022");
						urea_crea = false;
					}
				};
				creatinine.addActionListener(for_crea);
				
				solutePar.setBorder(titled3);
				
				add(solutePar);
				
				//
				final JCheckBox saveToCSV = new JCheckBox("Save results to CSV file:");
				final JTextField path = new JTextField();
				
				//Przycisk 'Count', 'About' i 'Show window with intermediate values'
				JPanel button = new JPanel ();
				JButton count = new JButton("Run");
				button.add(count);
				count.addActionListener(new ActionListener ()
				{
					public double[][] matrixB1 = new double[4][4];
					public double[][] matrixB = new double[4][4];
					public double[] matrixC1 = new double[4];
					public double[] matrixC = new double[4];
					public double[] matrixG = new double[4];
					public double[] matrixR = new double[4];
					
					public void actionPerformed (ActionEvent event)
					{
						showStatus("Counting...");
						//SZCZYTYWANIE DANYCH	
						
						//czas
						final int tStart = 0;
						final int tFazy = Integer.parseInt(t_d.getText());
						final int tEnd = Integer.parseInt(t_di.getText());
						
						//Solute Settings
						double C_t0 = Double.parseDouble(Ct0.getText());
						double g_24 = Double.parseDouble(G24.getText());
						double k_s = Double.parseDouble(ks.getText());
						double f_ew = Double.parseDouble(few.getText());
						
						//Patient Settings
						final double v_t0 = Double.parseDouble(Vt0.getText());
						final double v_uf = Double.parseDouble(Vuf.getText());
						double h = Double.parseDouble(H.getText());
						double q_x = Double.parseDouble(Qx.getText());
						double e_x = Double.parseDouble(Ex.getText());
						
						//Model Parametr
						double q_c = Double.parseDouble(Qc.getText());
						double q_f = Double.parseDouble(Qf.getText());
						double v_x = Double.parseDouble(Vx.getText());
						double v_b = Double.parseDouble(Vb.getText());
						double f_p = Double.parseDouble(fp.getText());
						double f_pw = Double.parseDouble(fpw.getText());
						double f_QH = Double.parseDouble(fQH.getText());
						double f_VH = Double.parseDouble(fVH.getText());
						double f_ecv = Double.parseDouble(fecv.getText());
						
						//LICZENIE FAZY 0.
						final double q_uf = v_uf / tFazy;
						final double q_in = -v_uf / (tEnd - tFazy);
						double q_s = q_c - q_f;
						double q_h = q_s * f_QH;
						double q_l = q_s * (1.0 - f_QH);
						double kappa = k_s * ( (f_ew / f_pw) * (h / (1.0 - h) ) + 1.0 ) / f_ew;
						double tau_x = v_x / q_x;
						double tau_h = v_b * f_VH / q_h;
						double tau_l = v_b * (1.0 - f_VH) / q_l;
						double f_jx = (1.0 - h * f_p) * f_pw + h * f_p * (1.0 - Math.exp(-(kappa * tau_x))) * f_ew;
						double f_jh = (1.0 - h) * f_pw + h * (1.0 - Math.exp(-(kappa * tau_h))) * f_ew;
						double f_jl = (1.0 - h) * f_pw + h * (1.0 - Math.exp(-(kappa * tau_l))) * f_ew;
						double f_jv = f_QH * f_jh + (1.0 - f_QH) * f_jl;
						double f_ja = (f_jv * q_s + f_jx * q_x) / (q_s + q_x);
						double f_jf = f_jx * q_x / q_f + f_ja * (1.0 - q_x/q_f);
						
						double F_h = q_h * f_jh;
						double F_l = q_l * f_jl;
						double F_c = q_c * f_ja; 
						double F_f = q_f * f_jf;
						double F_ufH = q_uf * f_VH;
						double F_ufL = q_uf * (1.0 - f_VH);
						double F_ufHi = q_uf * f_VH * (1.0 - f_ecv);
						double F_ufLi = q_uf * (1.0 - f_VH) * (1.0 - f_ecv);
						//
						//double F_inH = q_in * f_VH;
						//double F_inL = q_in * (1- f_VH);
						
						double K_c = k_s * (v_t0 + v_uf) * (1.0 - f_ecv);
						double K_h = K_c * f_VH;
						double K_l = K_c * (1.0 - f_VH);
						double K_d = q_x * f_jx * e_x + q_uf * (1.0 - e_x);				
						
						matrixB1[0][0] = -F_h - K_h + F_h * (F_h + F_ufH) / (F_c - F_f + K_d);
						matrixB1[0][1] =			K_h; 
						matrixB1[0][2] =			F_h * (F_l + F_ufL) / (F_c - F_f + K_d);
						matrixB1[0][3] =			0.0;
						matrixB1[1][0] =		K_h - F_ufHi;
						matrixB1[1][1] =			-K_h + F_ufHi;
						matrixB1[1][2] =			0.0;
						matrixB1[1][3] =			0.0;
						matrixB1[2][0] =		F_l * (F_h + F_ufH) / (F_c - F_f + K_d);
						matrixB1[2][1] =			0.0;
						matrixB1[2][2] =			-F_l - K_l + F_l * (F_l + F_ufL) / (F_c - F_f + K_d);
						matrixB1[2][3] =			K_l;
						matrixB1[3][0] =		0.0; 
						matrixB1[3][1] =			0.0;
						matrixB1[3][2] =			K_l - F_ufLi;
						matrixB1[3][3] =			-K_l + F_ufLi;
						
						sizeOfMatrix = matrixB.length;
						lambda = new double[sizeOfMatrix];
						
						//wektor c dla fazy 1
						//matrixC[0] = C_t0; matrixC[1] = C_t0; matrixC[2] = C_t0; matrixC[3] = C_t0;
						matrixC1[0] = C_t0; matrixC1[1] = C_t0; matrixC1[2] = C_t0; matrixC1[3] = C_t0;
						
						//Wektor r
						matrixR[0] = f_VH * f_ecv;
						matrixR[1] = f_VH * (1.0 - f_ecv);
						matrixR[2] = (1.0 - f_VH) * f_ecv;
						matrixR[3] = (1.0 - f_VH) * (1.0 - f_ecv);
						
						
						//Wektor g
						matrixG = new double[sizeOfMatrix];
						
						if (urea_crea == false)
						{
							matrixG[0] = 0.0;
							matrixG[1] = 0.0;
							matrixG[2] = 0.0;
							matrixG[3] = g_24 * 113.2 / (24.0*60.0);
						}
						else
						{
							matrixG[0] = 0.0;
							matrixG[1] = g_24 * 60.06 / (24.0*60.0);
							matrixG[2] = 0.0;
							matrixG[3] = 0.0;						
						}
						
						
						//LICZENIE FAZY 1.
						Q = -q_uf;
						
						long before = System.currentTimeMillis();
						
						count(matrixB1, matrixC1, matrixR, matrixG);
						
						double[] lambda_1 = lambda;
						
						long now = System.currentTimeMillis();
						
						series = new XYSeries[sizeOfMatrix];
					
						//liczenie wartosci funkcji C
						double valC = 0;
						
						for (int i = 0; i < sizeOfMatrix; i++)
						{
							series[i] = new XYSeries ("Phase 1 Line no " + Integer.toString(i + 1));
							
							for (int j = tStart; j < tFazy + 1; j++)
							{
								valC = functionC(j, i, v_t0 + v_uf);
								series[i].add(j, valC);
							}
							matrixC[i] = valC;
						}
						
						//LICZENIE FAZY 2.
						
						Q = -q_in;
						
						K_c = k_s * v_t0 * (1.0 - f_ecv);
						K_h = K_c * f_VH;
						K_l = K_c * (1.0 - f_VH);
						
						double F_inHe = q_in * f_VH * f_ecv;
						double F_inLe = q_in *(1.0 - f_VH) * f_ecv;
						double F_inHi = q_in * f_VH * (1.0 - f_ecv);
						double F_inLi = q_in * (1.0 - f_VH) * (1.0 - f_ecv);
						
						matrixB[0][0] = -F_h - K_h + (F_h * (F_h) / (F_c - F_f)) + F_inHe;
						matrixB[0][1] = K_h;
						matrixB[0][2] = F_h*(F_l)/(F_c-F_f);
						matrixB[0][3] = 0.0;
												
						matrixB[1][0] = K_h;
						matrixB[1][1] = -K_h + F_inHi;
						matrixB[1][2] = 0.0;
						matrixB[1][3] = 0.0;
												
						matrixB[2][0] = F_h * (F_l) / (F_c - F_f);
						matrixB[2][1] = 0.0;
						matrixB[2][2] = -F_l - K_l + (F_l * (F_l)  / (F_c - F_f)) + F_inLe;
						matrixB[2][3] = K_l;
												
						matrixB[3][0] = 0.0;		
						matrixB[3][1] = 0.0; 
						matrixB[3][2] = K_l;
						matrixB[3][3] = -K_l + F_inLi;
						
						long before_2 = System.currentTimeMillis();
						
						count(matrixB, matrixC, matrixR, matrixG);
						
						long now_2 = System.currentTimeMillis();
						
						series2 = new XYSeries[sizeOfMatrix];
						
						//liczenie wartosci funkcji C dla 2. fazy
						for (int i = 0; i < sizeOfMatrix; i++)
						{
							series2[i] = new XYSeries ("Phase 2 Line no " + Integer.toString(i + 1));
							
							for (int j = tStart; j < (tEnd - tFazy) + 1; j++)
							{
								valC = functionC(j, i, v_t0);
								series2[i].add(j + tFazy, valC);
							}		
						} 		
						
						//Show IntermediateValuesWindow
						if (showMatrixValues.isSelected()) {
							final IntermediateValuesWindow window = new IntermediateValuesWindow(
									matrixB1, 
									matrixB,
									matrixC1, matrixC, matrixR, matrixG, lambda_1, lambda);
							window.setVisible(true);
							window.addClickOKListener(
									new ClickOKListener () {
										public void click(double[][] mB1, double[][] mB2, double[] c, double[] c2, double[] r, double[] g) {
											
											boolean sourceOfVectorC2 = window.getSourceOfVectorC2 ();
											
											if (!sourceOfVectorC2) {
												matrixC[0] = c2[0];
												matrixC[1] = c2[1];
												matrixC[2] = c2[2];
												matrixC[3] = c2[3];
											}
											
											//Elemets of vector R is 1?
											double result = 0.0;
											
											for (int k = 0; k < r.length; k++) {
												result += r[k];
											}
											
											if (result != 1) {
												warning("The sum of elements of the vector R is not equal to 1.");
											}
											//FAZA 1
											
											Q = -q_uf;
											
											long before = System.currentTimeMillis();
											
											count(mB1, c, r, g);
											
											long now = System.currentTimeMillis();
											
											series = new XYSeries[sizeOfMatrix];
										
											//liczenie wartosci funkcji C
											double valC = 0;
											
											for (int i = 0; i < sizeOfMatrix; i++)
											{
												series[i] = new XYSeries ("Phase 1 Line no " + Integer.toString(i + 1));
												
												for (int j = tStart; j < tFazy + 1; j++)
												{
													valC = functionC(j, i, v_t0 + v_uf);
													series[i].add(j, valC);
												}
												if (sourceOfVectorC2) {
													matrixC[i] = valC;
												}
											}
											
											if (!sourceOfVectorC2) {
												window.setValuesOfVectorC2(matrixC);
											}
											
											//FAZA 2
											Q = -q_in;
											
											long before_2 = System.currentTimeMillis();
											
											count(mB2, matrixC, r, g);
											
											long now_2 = System.currentTimeMillis();
											
											series2 = new XYSeries[sizeOfMatrix];
											
											//liczenie wartosci funkcji C dla 2. fazy
											for (int i = 0; i < sizeOfMatrix; i++)
											{
												series2[i] = new XYSeries ("Phase 2 Line no " + Integer.toString(i + 1));
												
												for (int j = tStart; j < (tEnd - tFazy) + 1; j++)
												{
													valC = functionC(j, i, v_t0);
													series2[i].add(j + tFazy, valC);
												}		
											} 		
											
											
											
											int i = 0;
											if (saveToCSV.isSelected()) {
												
												CSVWriter sheet = null;

												try {
													sheet = new CSVWriter( path.getText() );
												} catch (IOException e) {
													warning("Can not create a file: " + e.getLocalizedMessage());
												}
													
												final String[] head1 = { "", "", "", "", "PHASE 1, PHASE 2 from " + Integer.toString(tFazy + 1), "", "", "", ""};
												final String[] head2 = { "Time", "", "Curve 1", "", "Curve 2", "", "Curve 3", "", "Curve 4"};
												sheet.write( head1 );
												sheet.write( head2 );
												
												for (int k = 0; k < series[0].getItemCount() - 1; k++)
												{
													String value1 = "";
													String value2 = "";
													String value3 = "";
													String value4 = "";
													
													XYDataItem num = series[0].getDataItem(k);
													if (num != null) {
														value1 = Double.toString(num.getYValue());
													}
													else {
														value1 = "null";
													}
													
													num = series[1].getDataItem(k);
													if (num != null) {
														value2 = Double.toString(num.getYValue());
													}
													else {
														value2 = "null";
													}
													
													num = series[2].getDataItem(k);
													if (num != null) {
														value3 = Double.toString(num.getYValue());
													}
													else {
														value3 = "null";
													}
													
													num = series[3].getDataItem(k);
													if (num != null) {
														value4 = Double.toString(num.getYValue());
													}
													else {
														value4 = "null";
													}
													
													String[] s = { Integer.toString(i + 1), 
															"",
															value1, 
															"", 
															value2, 
															"", 
															value3, 
															"", 
															value4 };
													sheet.write(s);
													
													++i;
												}
												
												for (int j = 0; j < series2[0].getItemCount() - 1; j++)
												{
													String value1 = "";
													String value2 = "";
													String value3 = "";
													String value4 = "";
													
													XYDataItem num = series2[0].getDataItem(j);
													if (num != null) {
														value1 = Double.toString(num.getYValue());
													}
													else {
														value1 = "null";
													}
													
													num = series2[1].getDataItem(j);
													if (num != null) {
														value2 = Double.toString(num.getYValue());
													}
													else {
														value2 = "null";
													}
													
													num = series2[2].getDataItem(j);
													if (num != null) {
														value3 = Double.toString(num.getYValue());
													}
													else {
														value3 = "null";
													}
													
													num = series2[3].getDataItem(j);
													if (num != null) {
														value4 = Double.toString(num.getYValue());
													}
													else {
														value4 = "null";
													}
													
													String[] s = { Integer.toString(i + 1), 
															"",
															value1, 
															"", 
															value2, 
															"", 
															value3, 
															"", 
															value4 };
													sheet.write(s);
													
													++i;
												}
												sheet.close ();
											}
											
											//POKAZYWANIE WYNIKU
											showStatus("Showing chart...");
											
											ChartWindow win = new ChartWindow( createChart() );
											
											
											if (!wynik)
											{
												warning ("Warning: some eigenvalues should be complex, the graphs may be irrelevant");
											}
											
											showStatus( "Done. Counted in " + ((now_2 - before_2) + (now - before)) + " miliseconds");
										}
									}
							);
						}
						
						int i = 0;
						if (saveToCSV.isSelected()) {
							
							CSVWriter sheet = null;

							try {
								sheet = new CSVWriter( path.getText() );
							} catch (IOException e) {
								warning("Can not create a file: " + e.getLocalizedMessage());
							}
								
							final String[] head1 = { "", "", "", "", "PHASE 1, PHASE 2 from " + Integer.toString(tFazy + 1), "", "", "", ""};
							final String[] head2 = { "Time", "", "Curve 1", "", "Curve 2", "", "Curve 3", "", "Curve 4"};
							sheet.write( head1 );
							sheet.write( head2 );
							
							for (int k = 0; k < series[0].getItemCount() - 1; k++)
							{
								String value1 = "";
								String value2 = "";
								String value3 = "";
								String value4 = "";
								
								XYDataItem num = series[0].getDataItem(k);
								if (num != null) {
									value1 = Double.toString(num.getYValue());
								}
								else {
									value1 = "null";
								}
								
								num = series[1].getDataItem(k);
								if (num != null) {
									value2 = Double.toString(num.getYValue());
								}
								else {
									value2 = "null";
								}
								
								num = series[2].getDataItem(k);
								if (num != null) {
									value3 = Double.toString(num.getYValue());
								}
								else {
									value3 = "null";
								}
								
								num = series[3].getDataItem(k);
								if (num != null) {
									value4 = Double.toString(num.getYValue());
								}
								else {
									value4 = "null";
								}
								
								String[] s = { Integer.toString(i + 1), 
										"",
										value1, 
										"", 
										value2, 
										"", 
										value3, 
										"", 
										value4 };
								sheet.write(s);
								
								++i;
							}
							
							for (int j = 0; j < series2[0].getItemCount() - 1; j++)
							{
								String value1 = "";
								String value2 = "";
								String value3 = "";
								String value4 = "";
								
								XYDataItem num = series2[0].getDataItem(j);
								if (num != null) {
									value1 = Double.toString(num.getYValue());
								}
								else {
									value1 = "null";
								}
								
								num = series2[1].getDataItem(j);
								if (num != null) {
									value2 = Double.toString(num.getYValue());
								}
								else {
									value2 = "null";
								}
								
								num = series2[2].getDataItem(j);
								if (num != null) {
									value3 = Double.toString(num.getYValue());
								}
								else {
									value3 = "null";
								}
								
								num = series2[3].getDataItem(j);
								if (num != null) {
									value4 = Double.toString(num.getYValue());
								}
								else {
									value4 = "null";
								}
								
								String[] s = { Integer.toString(i + 1), 
										"",
										value1, 
										"", 
										value2, 
										"", 
										value3, 
										"", 
										value4 };
								sheet.write(s);
								
								++i;
							}
							sheet.close ();
						}
						
						//POKAZYWANIE WYNIKU
						showStatus("Showing chart...");
						
						ChartWindow win = new ChartWindow( this.createChart() );
						
						if (!wynik)
						{
							warning ("Warning: some eigenvalues should be complex, the graphs may be irrelevant");
						}
						
						showStatus( "Done. Counted in " + ((now_2 - before_2)+(now-before))  + " miliseconds");
					}
					
					/**
					 * Liczy operacje na macierzach
					 * @param double[][] mB
					 * @param double[] mc
					 * @param double[] mr
					 * @param double[] mg
					 */
					private void count(double[][] mB, double[] mc, double[] mr, double[] mg)
					{						
						Matrix B = new Matrix(mB);	
						Matrix c = new Matrix(mc, mc.length);
						Matrix g = new Matrix(mg, mg.length);
						
						//copyB = B do potegi -1
						Matrix copyB = B.inverse();
						Matrix copy_g = g.uminus();
						
						x = copyB.times(copy_g);
						//Krok 2. 
						//Budujemy macierz A
						double[][] A = new double[sizeOfMatrix][sizeOfMatrix];
						
						for (int i = 0; i<sizeOfMatrix; i++)
						{
							for (int j = 0; j<sizeOfMatrix; j++)
							{
								A[i][j] =  mB[i][j] / (Q * mr[i]) ;
							}
						}
						
						//Krok 3.
						Matrix matA = new Matrix(A);
						EigenvalueDecomposition val = matA.eig();
						lambda = val.getRealEigenvalues();
						Matrix Y = val.getV();
						
						//Krok 4. 
						Matrix copyY = Y.inverse();
						Matrix seFactor = c.minus(x);
						
						Matrix s = copyY.times(seFactor);
						
						//Krok 5.
						double[][] S = new double[sizeOfMatrix][sizeOfMatrix];
						S = diag(s);
						Matrix matS = new Matrix(S);
						
						//Krok 6.
						X = Y.times(matS);
						
						wynik = test(A);
						
					}
					
					/**
					* Show warning
					* @param text
					*/
					public void warning(String text)
					{
						
						JOptionPane.showConfirmDialog(
								MedCalApp.this,
								text,
								"Warning",
								JOptionPane.OK_CANCEL_OPTION,
								JOptionPane.WARNING_MESSAGE);
					}
					
					/**
					* Funkcja sprawdza poprawnosc wyniku. 
					* @param double[][] mat
					* @return boolean
					*/
					private boolean test(double[][] A)
					{
						double[][] B = A;
						
						int matrixSize = A.length;
						
						Matrix matrixA = new Matrix (A);
						EigenvalueDecomposition matrixAEig = matrixA.eig();
						double[] eigenValue = matrixAEig.getRealEigenvalues();
						
						double t = 10E-15;
						
						for (int k = 0; k < matrixSize; k++) {
							
							for (int m = 0; m < matrixSize; m++) {
								for (int n = 0; n < matrixSize; n++) {
									B[m][n] = A[m][n];
								}
							}
							
							for (int m = 0; m < matrixSize; m++) {
								B[m][m] = B[m][m] - eigenValue[k];
							}
							
							Matrix matrixB = new Matrix(B);
							double detB = matrixB.det();
							
							if ( (detB < -t ) || (detB>t) ) {
								continue;
							}
							else  { return false; }
						}
						return true;
					}
					
					/**
					* Tworzy nowa macierz wypelniona zerami, a nastepnie rozkalda na jej przekatnej 
					* kolejne wartosci macierza podanego
					* w argumencie.
					* @param Matrix s
					* @return double[][]
					*/
					private double[][] diag(Matrix s)
					{
						
						double[][] d = new double[sizeOfMatrix][sizeOfMatrix];
						double[][] tabS = s.getArray();
						
						//Zerujemy tablice
						for (int j = 0; j<sizeOfMatrix; j++)
						{
							Arrays.fill(d[j], 0);
						}
						
						//rozklad na przekatnej
						for (int i = 0; i<sizeOfMatrix; i++)
						{
							d[i][i] = tabS[i][0];
						}

						return d;
					}
					/**
					 * Liczy wartosc funkcji C na podstawie podanego czasu.
					 * @param time
					 * @param which
					 * @param vo
					 * @return double 
					 */
					private double functionC (int time, int which, double vo)
					{ 
						double a = Q/vo;
						double w = 1.0 + a * time;
						double[][] matrixX = X.getArray();
						
						double wynik = 0.0;
						for (int i = 0; i < sizeOfMatrix; i++){
							wynik += matrixX[which][i] * Math.pow(w, lambda[i]);
						}
						wynik += x.get(which, 0); 
						return wynik;
					}
					/**
					* Tworzy wykres na podstawie danych z tablic series i series2.
					* Zwraca obiekt JFreeChart.
					*/
					public JFreeChart createChart()
					{
						
						final XYSeriesCollection dataset = new XYSeriesCollection();
						
						for (int i = 0; i < sizeOfMatrix; i++)
						{
							dataset.addSeries(series[i]);			
						}
						
						for (int i = 0; i < sizeOfMatrix; i++)
						{
							dataset.addSeries(series2[i]);
						}
						
						String kindOf = new String();
						
						if (urea_crea) {
							kindOf = "UREA";
						}
						else {
							kindOf = "CREATININE";
						}
						
						//Tworzymy wykres XY
						JFreeChart chart = ChartFactory.createXYLineChart(
							"COMPARTMENTAL CONCENTRATIONS (" + kindOf + ")",//Tytuł
							"TIME IN MINUTES", // x-axis Opis
							"CONCENTRATION IN GRAMS PER LITER", // y-axis Opis
							dataset, // Dane
							PlotOrientation.VERTICAL, // Orjentacja wykresu /HORIZONTAL
							true, // pozkaż legende
							true, // podpowiedzi tooltips
							false
						);
						
				        return chart;
					} 
				});
				JButton aboutAndHelp = new JButton("About");
				aboutAndHelp.addActionListener( new ActionListener ()
				{
					public void actionPerformed (ActionEvent event)
					{
						aboutFrame = new JFrame ();
						aboutFrame.setSize(320, 300);
						aboutFrame.setTitle("About and Help");
						aboutFrame.setVisible(true);
						
						JLabel des = new JLabel(
								"<html> <center>" +
								"<h1> " +
								"Applet for Hemodialysis " +
								"</h1> " +
								"<h2> " +
								"DA-RBF model </h2>" +
								"<hr> " +
								"<h3> Model formulas: </h3> Daniel Schneditz and Przemyslaw Korohoda" +
								"<h3> Programmer: </h3> Dawid Worek" +
								"</center> " +
								"</html>");
						
						JPanel panel = new JPanel ();
						
						JButton okButton = new JButton ("OK");
						okButton.addActionListener( new ActionListener ()
						{
							public void actionPerformed (ActionEvent event)
							{
								aboutFrame.setVisible(false); 
							}
						});
						panel.add(okButton);
						
						aboutFrame.add(des, BorderLayout.CENTER);
						aboutFrame.add(panel, BorderLayout.SOUTH);
					}
				});
				
				button.add(aboutAndHelp);
				
				showMatrixValues = new JCheckBox("Show window with intermediate values");
				
				button.add(showMatrixValues);
			
				final JButton chooseFile = new JButton("...");
				path.setEnabled(false);
				chooseFile.setEnabled(false);
				
				ActionListener chooseOutputFile = new ActionListener ()
				{
					public void actionPerformed(ActionEvent event)
					{
						if (saveToCSV.isSelected()) {
							path.setEnabled(true);
							chooseFile.setEnabled(true);
						}
						else {
							path.setEnabled(false);
							chooseFile.setEnabled(false);
						}
					}
				};
				saveToCSV.addActionListener(chooseOutputFile);
				
				ActionListener runChooser = new ActionListener()
				{
					public void actionPerformed(ActionEvent event)
					{
						final JFileChooser chooser = new JFileChooser();
						chooser.setCurrentDirectory(new File("."));
						chooser.setFileFilter( new FileNameExtensionFilter("CSV", "csv"));
						chooser.showSaveDialog(t_o);
						path.setText(chooser.getSelectedFile().getPath() + ".csv");
					}
				};
				chooseFile.addActionListener(runChooser);
				
				JPanel filePanel = new JPanel();
				filePanel.setLayout(new GridLayout(3,1));
				filePanel.add(saveToCSV);
				filePanel.add(path);
				filePanel.add(chooseFile);
				button.add(filePanel);
				
				add(button, BorderLayout.SOUTH);
			}
		});
	}
	//Okno, w ktorym pojawia sie wykres
	private JFrame aboutFrame;
	
	//Pola tektowe
	private JTextField t_o, t_d, t_di;
	
	private JTextField Qc, Qf, Vx, Vb, fp, fpw, few, fQH, fVH, fecv;
	
	private JTextField Vt0, Vuf, H, Qx, Ex;
	
	private JTextField Ct0, G24, ks;
	//Koniec pol tekstowych
	
	//Macierze
	private Matrix x;
	private Matrix X;
	
	
	//Kolekcje elementow do wpisania do tablicy
	//Seria danych dla fazy 1
	private XYSeries[] series = null;
	
	//Seria danych dla fazy 2
	private XYSeries[] series2 = null;

	private double Q = 0;
	
	private double[] lambda;
	
	//Rozmiar macierza B
	private int sizeOfMatrix;
	
	//Mocznik czy kreatinina?
	private boolean urea_crea = false;
	
	//Prawdziwosc wyniku
	private boolean wynik = true;
	//Zapis do pliku?
	private boolean saveToFile = false;
	
	//show intermediate values (button), and save to XLS file?
	private JCheckBox showMatrixValues, saveToXLS;
	
	private JTextField path;
	private JButton chooseFile;
}