/*
 * Decompiled with CFR 0.152.
 */
package gl4java;

import gl4java.GL4JavaInitException;
import gl4java.GLCapabilities;
import gl4java.GLFunc;
import gl4java.GLRunnable;
import gl4java.GLUFunc;
import gl4java.drawable.GLDrawableFactory;
import gl4java.drawable.SunJDK13GLDrawableFactory;
import gl4java.jau.awt.WinHandleAccess;
import gl4java.system.GljMSJDirect;
import gl4java.utils.glf.GLF;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class GLContext
implements Runnable {
    protected boolean isInitialized = false;
    protected static boolean libsLoaded = false;
    public static final String defGljMSWinLib = "GL4JavaGljMSJDirect";
    public static final String defGljLib = "GL4JavaJauGljJNI";
    public static final String defGLFuncClass = "GLFuncJauJNI";
    public static final String defGLFunc14Class = "GLFunc14JauJNI";
    public static final String defGLUFuncClass = "GLUFuncJauJNI";
    public static final String defGLUFunc14Class = "GLUFunc14JauJNI";
    public static final String defNativeGLLibX11 = "libGL.so";
    public static final String defNativeGLLibMacOS9 = "\\pOpenGLLibrary";
    public static final String defNativeGLLibMacOSX = "libGL.so";
    public static final String defNativeGLLibWin32 = "OPENGL32.DLL";
    public static final String defNativeGLULibX11 = "libGLU.so";
    public static final String defNativeGLULibMacOS9 = "\\pOpenGLULibrary";
    public static final String defNativeGLULibMacOSX = "libGLU.so";
    public static final String defNativeGLULibWin32 = "GLU32.DLL";
    public static final String version = "2.8.0.8";
    public static boolean gljClassDebug = false;
    public static boolean gljThreadDebug = false;
    public static boolean gljNativeDebug = false;
    protected long glContext = 0L;
    protected static int glContextNumber = 0;
    protected GLContext sharedGLContext;
    protected long sharedGLContextNative = 0L;
    protected long pixmapHandle = 0L;
    protected long windowHandle = 0L;
    protected long displayHandle = 0L;
    private int createwinw;
    private int createwinh;
    private int createwinx;
    private int createwiny;
    private boolean threadRunning = false;
    private boolean destroyWindow = false;
    protected Container containerWindow = null;
    protected Dimension offScrnSize = null;
    long pData = 0L;
    protected boolean glEnabled = true;
    protected boolean offScreenRenderer = false;
    protected boolean createOwnWindow = false;
    protected GLCapabilities glCaps = null;
    protected boolean mustResize = false;
    protected Dimension size = null;
    protected Component _comp = null;
    protected Component _compHeavy = null;
    public static final int OsWindoof = -1;
    public static final int OsUnknown = 0;
    public static final int OsX11 = 1;
    public static final int OsMac9 = 2;
    public static final int OsMacX = 3;
    private static int osType = 0;
    private static boolean isNetscapeJvm = false;
    private static boolean isMicrosoftJvm = false;
    private static boolean isIBMJvm = false;
    private static boolean useMSJDirect = false;
    private static String jvmVendor = null;
    private static String jvmVersion = null;
    private static int jvmVersionMajor = 1;
    private static int jvmVersionMinor = 1;
    private static String osName = null;
    private static String jniEXTsuff = "";
    private GLFunc gl = null;
    private GLUFunc glu = null;
    private Thread ctxThread = null;
    private Thread nextThread = null;

    public final long getNativeGLContext() {
        return this.glContext;
    }

    public static final int getNativeGLContextNumber() {
        return glContextNumber;
    }

    public final long getNativeWindoHandle() {
        return this.windowHandle;
    }

    public final GLContext getSharedGLContext() {
        return this.sharedGLContext;
    }

    public static int getNativeOSType() {
        return osType;
    }

    public static String getNativeOSName() {
        return osName;
    }

    public final GLCapabilities getGLCapabilities() {
        return this.glCaps;
    }

    public final boolean isDoubleBuffer() {
        return this.glCaps.getDoubleBuffered();
    }

    public final int getStencilBitNumber() {
        return this.glCaps.getStencilBits();
    }

    public final int getAccumSize() {
        return this.glCaps.getAccumRedBits() + this.glCaps.getAccumGreenBits() + this.glCaps.getAccumBlueBits() + this.glCaps.getAccumAlphaBits();
    }

    public final boolean isStereoView() {
        return this.glCaps.getStereo();
    }

    public final boolean isRGBA() {
        return this.glCaps.getTrueColor();
    }

    public final boolean isOwnWindowCreated() {
        return this.createOwnWindow;
    }

    public static final boolean loadNativeLibraries(String string, String string2, String string3) {
        return GLContext.doLoadNativeLibraries(string, null, null);
    }

    public static final boolean doLoadNativeLibraries(String string, String string2, String string3) {
        boolean bl;
        Object[] objectArray;
        Method method;
        Object object;
        if (libsLoaded) {
            return true;
        }
        if (gljClassDebug) {
            System.out.println("GLContext.doLoadNativeLibraries will do it !");
        }
        jvmVendor = System.getProperty("java.vendor");
        jvmVersion = System.getProperty("java.version");
        if (gljClassDebug) {
            System.out.println("jvm vendor: " + jvmVendor);
            System.out.println("jvm version: " + jvmVersion);
        }
        int n = 0;
        int n2 = jvmVersion.indexOf(".", n);
        String string4 = null;
        if (n2 > 0) {
            string4 = jvmVersion.substring(n, n2);
            try {
                jvmVersionMajor = Integer.valueOf(string4);
            }
            catch (Exception exception) {
                System.out.println("Not a number: " + string4 + " (" + jvmVersion + ")");
            }
        }
        if ((n2 = jvmVersion.indexOf(".", n = n2 + 1)) < 0) {
            n2 = jvmVersion.length();
        }
        if (0 < n && n < n2) {
            string4 = jvmVersion.substring(n, n2);
            try {
                jvmVersionMinor = Integer.valueOf(string4);
            }
            catch (Exception exception) {
                System.out.println("Not a number: " + string4 + " (" + jvmVersion + ")");
            }
        }
        if (gljClassDebug) {
            System.out.println("jvm version (parsed): major: " + jvmVersionMajor + ", minor: " + jvmVersionMinor);
        }
        isNetscapeJvm = jvmVendor != null && jvmVendor.indexOf("Netscape") >= 0;
        isMicrosoftJvm = jvmVendor != null && jvmVendor.indexOf("Microsoft") >= 0;
        isIBMJvm = jvmVendor != null && jvmVendor.indexOf("IBM") >= 0;
        osName = System.getProperty("os.name");
        osType = osName.startsWith("Wind") ? -1 : (osName.startsWith("Mac OS X") ? 3 : (osName.startsWith("Mac OS") ? 2 : 1));
        String[] stringArray = null;
        jniEXTsuff = jvmVersionMajor >= 2 || jvmVersionMajor == 1 && jvmVersionMinor >= 4 ? "14" : (jvmVersionMajor == 1 && jvmVersionMinor >= 3 && !isIBMJvm && !isMicrosoftJvm ? "13" : (jvmVersionMajor == 1 && jvmVersionMinor >= 2 ? "12" : ""));
        if (string == null) {
            string = defGljLib + jniEXTsuff;
        }
        if (string2 == null) {
            string2 = osType == -1 ? defNativeGLLibWin32 : (osType == 2 ? defNativeGLLibMacOS9 : (osType == 3 ? "libGL.so" : "libGL.so"));
        }
        if (string3 == null) {
            string3 = osType == -1 ? defNativeGLULibWin32 : (osType == 2 ? defNativeGLULibMacOS9 : (osType == 3 ? "libGLU.so" : "libGLU.so"));
        }
        if (osType == -1 && isMicrosoftJvm) {
            stringArray = new String[]{string, defGljMSWinLib};
            useMSJDirect = true;
        } else {
            stringArray = new String[]{string};
            useMSJDirect = false;
        }
        final String[] stringArray2 = stringArray;
        if (isNetscapeJvm) {
            System.out.println("Netscape JVM try to get Privileges");
            try {
                Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
                object = new Class[]{Class.forName("java.lang.String")};
                method = clazz.getMethod("enablePrivilege", (Class<?>)object);
                objectArray = new Object[1];
                objectArray[0] = new String("UniversalLinkAccess");
                method.invoke(clazz, objectArray);
                System.out.println("Netscape-Privilege: enabled UniversalLinkAccess priv.");
            }
            catch (Exception exception) {
                System.out.println("Not enabled Netscape-Privilege: UniversalLinkAccess priv.");
            }
        }
        if (jvmVersionMajor >= 2 || jvmVersionMajor == 1 && jvmVersionMinor >= 2) {
            object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    int n = 0;
                    Object var2_2 = null;
                    boolean[] blArray = new boolean[stringArray2.length];
                    n = 0;
                    while (n < stringArray2.length) {
                        blArray[n] = false;
                        ++n;
                    }
                    n = 0;
                    while (n < stringArray2.length) {
                        do {
                            try {
                                System.loadLibrary(stringArray2[n]);
                                blArray[n] = true;
                                if (!gljClassDebug) continue;
                                System.out.println("loaded native library: " + stringArray2[n]);
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                System.out.println("Sorry, can't find the library: " + stringArray2[n] + "\n" + unsatisfiedLinkError);
                                stringArray2[n] = null;
                            }
                        } while (!blArray[n] && stringArray2[n] != null);
                        ++n;
                    }
                    n = 0;
                    while (n < stringArray2.length) {
                        if (!blArray[n]) {
                            return new Boolean(false);
                        }
                        ++n;
                    }
                    return new Boolean(true);
                }
            });
            bl = (Boolean)object;
        } else {
            int n3 = 0;
            method = null;
            objectArray = new boolean[stringArray2.length];
            n3 = 0;
            while (n3 < stringArray2.length) {
                objectArray[n3] = false;
                ++n3;
            }
            n3 = 0;
            while (n3 < stringArray2.length) {
                do {
                    try {
                        System.loadLibrary(stringArray2[n3]);
                        objectArray[n3] = true;
                        if (!gljClassDebug) continue;
                        System.out.println("loaded native library: " + stringArray2[n3]);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        System.out.println("Sorry, can't find the library: " + stringArray2[n3] + "\n" + unsatisfiedLinkError);
                        stringArray2[n3] = null;
                    }
                } while (!objectArray[n3] && stringArray2[n3] != null);
                ++n3;
            }
            bl = true;
            n3 = 0;
            while (n3 < stringArray2.length) {
                if (!objectArray[n3]) {
                    bl = false;
                    break;
                }
                ++n3;
            }
        }
        if (bl) {
            if (gljClassDebug) {
                System.out.println("fetching GL/GLU functions ...");
            }
            if (GLContext.gljFetchGLFunctions(string2, string3, true)) {
                System.out.println("fetched GL/GLU functions succesfully !");
                libsLoaded = true;
            } else {
                System.out.println("GL4Java-ERROR: can't fetch GL/GLU functions !");
            }
        }
        if (!libsLoaded) {
            System.exit(1);
        }
        return libsLoaded;
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        boolean bl4 = true;
        if (stringArray.length == 0) {
            System.out.println("usage: java gl4java.GLContext <options>, where options can be: ");
            System.out.println("\t-GLLib <OpenGL Libname> \t choose a custom OpenGL native library (default: libGL, or OPENGL32, ..)");
            System.out.println("\t-GLULib <GLU Libname> \t choose a custom GLU native library (default: libGLU, or GLU32, ..)");
            System.out.println("\t-gljlib <glj-libname> \t choose a custom gl4java-glj-lib native library (default: GL4JavaJauGljJNI)");
            System.out.println("\t-glclass <gl-class> \t choose a custom gl4java-gl-class java GLFunc implementation (default: GLFuncJauJNI)");
            System.out.println("\t-gluclass <glu-class> \t choose a custom gl4java-glu-class java GLUFunc implementation (default: GLUFuncJauJNI)");
            System.out.println("\t-info \t creates a GLContext and prints all avaiable information of GL/GLU and GL4Java");
            System.out.println("\t-infotxt \t like -info, but exits straight after -info !");
            System.out.println("\t-noFactory \t creates a GLContext without the new GLDrawableFactory API");
            System.exit(0);
        }
        while (stringArray.length > n) {
            if (stringArray[n].equals("-GLLib")) {
                if (stringArray.length > ++n) {
                    string = stringArray[n];
                }
            } else if (stringArray[n].equals("-GLULib")) {
                if (stringArray.length > ++n) {
                    string2 = stringArray[n];
                }
            } else if (stringArray[n].equals("-gljlib")) {
                if (stringArray.length > ++n) {
                    string3 = stringArray[n];
                }
            } else if (stringArray[n].equals("-glclass")) {
                if (stringArray.length > ++n) {
                    string4 = stringArray[n];
                }
            } else if (stringArray[n].equals("-gluclass")) {
                if (stringArray.length > ++n) {
                    string5 = stringArray[n];
                }
            } else if (stringArray[n].equals("-info")) {
                bl = true;
            } else if (stringArray[n].equals("-infotxt")) {
                bl = true;
                bl2 = true;
            } else if (stringArray[n].equals("-noFactory")) {
                bl3 = true;
            } else {
                System.out.println("illegal arg " + n + ": " + stringArray[n]);
                bl4 = false;
            }
            ++n;
        }
        gljNativeDebug = true;
        gljClassDebug = true;
        GLFunc gLFunc = null;
        GLUFunc gLUFunc = null;
        if (GLContext.doLoadNativeLibraries(string3, string, string2)) {
            System.out.println("native Libraries loaded succesfull");
        } else {
            System.out.println("native library NOT loaded complete");
            bl4 = false;
        }
        gLFunc = GLContext.createGLFunc(string4);
        if (gLFunc != null) {
            System.out.println("GLFunc implementation " + gLFunc.getClass().getName() + " created succesfull");
        } else {
            System.out.println("GLFunc implementation " + string4 + " not created");
            bl4 = false;
        }
        gLUFunc = GLContext.createGLUFunc(string5);
        if (gLUFunc != null) {
            System.out.println("GLUFunc implementation " + gLUFunc.getClass().getName() + " created succesfull");
        } else {
            System.out.println("GLUFunc implementation " + string5 + " not created");
            bl4 = false;
        }
        if (bl && bl4) {
            Object object;
            Frame frame = new Frame("GL4Java Info");
            ((Component)frame).setSize(10, 10);
            Canvas canvas = null;
            GLCapabilities gLCapabilities = new GLCapabilities();
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory();
            if (bl3 || !(gLDrawableFactory instanceof SunJDK13GLDrawableFactory)) {
                canvas = new Canvas();
            } else {
                object = (SunJDK13GLDrawableFactory)gLDrawableFactory;
                canvas = new Canvas(((SunJDK13GLDrawableFactory)object).getGraphicsConfiguration(gLCapabilities));
            }
            canvas.setVisible(true);
            canvas.setSize(50, 50);
            frame.add("Center", canvas);
            ((Component)frame).setSize(60, 60);
            ((Component)frame).setVisible(true);
            object = new GLContext((Component)canvas, gLFunc, gLUFunc, gLCapabilities, null);
            Frame frame2 = ((GLContext)object).gljShowVersions();
            frame2.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((GLContext)object).gljDestroy();
            if (bl2) {
                System.exit(0);
            }
        }
    }

    public static String getJVMVersion() {
        return jvmVersion;
    }

    public static int getJVMVersionMajor() {
        return jvmVersionMajor;
    }

    public static int getJVMVersionMinor() {
        return jvmVersionMinor;
    }

    public static String getJVMVendor() {
        return jvmVendor;
    }

    public static boolean isNetscapeJVM() {
        return isNetscapeJvm;
    }

    public static boolean isMicrosoftJVM() {
        return isMicrosoftJvm;
    }

    protected GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, Dimension dimension, GLCapabilities gLCapabilities, GLContext gLContext) {
        this._comp = component;
        this.gl = gLFunc;
        this.glu = gLUFunc;
        this.createOwnWindow = bl;
        this.offScreenRenderer = bl2;
        this.offScrnSize = dimension;
        this.glCaps = gLCapabilities;
        this.sharedGLContext = gLContext;
        if (this.sharedGLContext != null) {
            this.sharedGLContextNative = (int)this.sharedGLContext.getNativeGLContext();
        }
        while (component != null && component.getPeer() instanceof LightweightPeer) {
            component = component.getParent();
        }
        this._compHeavy = component;
        Graphics graphics = null;
        if (this._compHeavy != null) {
            if (!this._comp.isVisible()) {
                this.setVisible(true);
            }
            if ((graphics = this._compHeavy.getGraphics()) == null) {
                System.out.println("got empty Graphics");
            }
        } else {
            System.out.println("got empty Component");
        }
        if (this._comp != null && graphics != null) {
            int n = 0;
            do {
                this.createGLContext(graphics);
                if (this.gljIsInit()) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!this.gljIsInit() && ++n < 5);
        }
        if (gljClassDebug) {
            if (this.gljIsInit()) {
                System.out.println("GLContext GLContext() succeded");
            } else {
                System.out.println("GLContext GLContext() failed");
            }
        }
    }

    protected GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, int n2, GLContext gLContext, Dimension dimension) {
        this(component, gLFunc, gLUFunc, bl, bl2, dimension, new GLCapabilities(bl3, bl4, bl5, n, n2, n2, n2, n2), gLContext);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, GLCapabilities gLCapabilities, GLContext gLContext) {
        this(component, gLFunc, gLUFunc, false, false, null, gLCapabilities, gLContext);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, GLContext gLContext) {
        this(component, gLFunc, gLUFunc, bl, false, bl2, bl3, bl4, n, n2, gLContext, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2) {
        this(component, gLFunc, gLUFunc, bl, false, bl2, bl3, bl4, n, n2, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        this(component, gLFunc, gLUFunc, bl, false, bl2, bl3, bl4, n, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, bl3, n, n2, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, int n) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, bl3, n, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, bl3, 0, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, true, 0, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc) {
        this(component, gLFunc, gLUFunc, false, false, true, false, true, 0, 0, null, null);
    }

    public static final GLContext createOffScreenCtx(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, int n, int n2, GLContext gLContext) {
        return new GLContext(component, gLFunc, gLUFunc, false, true, false, bl, bl2, n, n2, gLContext, null);
    }

    public static final GLContext createOffScreenCtx(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, int n, int n2, GLContext gLContext, Dimension dimension) {
        return new GLContext(component, gLFunc, gLUFunc, false, true, false, bl, bl2, n, n2, gLContext, dimension);
    }

    protected void finalize() throws Throwable {
        this.gljDestroy();
        super.finalize();
    }

    public final void setGLFunc(GLFunc gLFunc) {
        this.gl = gLFunc;
    }

    public final void setGLUFunc(GLUFunc gLUFunc) {
        this.glu = gLUFunc;
    }

    public final GLFunc getGLFunc() {
        return this.gl;
    }

    public final GLUFunc getGLUFunc() {
        return this.glu;
    }

    public static final GLFunc createGLFunc(String string) {
        String string2 = "gl4java.";
        GLFunc gLFunc = null;
        Object var3_3 = null;
        if (string == null) {
            string = jvmVersionMajor >= 2 || jvmVersionMajor == 1 && jvmVersionMinor >= 4 ? defGLFunc14Class : defGLFuncClass;
        }
        String string3 = string2 + string;
        try {
            var3_3 = Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            System.out.println("could not create instance of: " + string3);
        }
        if (var3_3 != null && var3_3 instanceof GLFunc) {
            gLFunc = var3_3;
        } else {
            System.out.println("Not a GLFunc implementation: " + string3);
        }
        return gLFunc;
    }

    public static final GLUFunc createGLUFunc(String string) {
        String string2 = "gl4java.";
        GLUFunc gLUFunc = null;
        Object var3_3 = null;
        if (string == null) {
            string = jvmVersionMajor >= 2 || jvmVersionMajor == 1 && jvmVersionMinor >= 4 ? defGLUFunc14Class : defGLUFuncClass;
        }
        String string3 = string2 + string;
        try {
            var3_3 = Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            System.out.println("could not create instance of: " + string3);
        }
        if (var3_3 != null && var3_3 instanceof GLUFunc) {
            gLUFunc = var3_3;
        } else {
            System.out.println("Not a GLUFunc implementation: " + string3);
        }
        return gLUFunc;
    }

    public void setVisible(boolean bl) {
        int n = 0;
        this._comp.setVisible(bl);
        while (this._comp.isVisible() != bl && n < 5) {
            this._comp.setVisible(bl);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                System.out.println("GLContext:setVisible: Error - " + exception);
            }
            ++n;
        }
        if (n >= 5) {
            System.out.println("GLContext:setVisible: Error, could not set to " + bl);
        }
    }

    public final void createGLContext(Graphics graphics) {
        String string = "gl4java.jau.awt.";
        WinHandleAccess winHandleAccess = null;
        try {
            Serializable serializable;
            if (gljClassDebug) {
                System.out.println("GLContext createGLContext");
            }
            if (this.pData == 0L) {
                if (useMSJDirect) {
                    if (gljClassDebug) {
                        System.out.println("using MSJDirect ...");
                    }
                    winHandleAccess = (WinHandleAccess)Class.forName(string + "windows.MSWin32HandleAccess").newInstance();
                    serializable = this._comp;
                    while (!(serializable instanceof Window) && !(serializable instanceof Applet)) {
                        serializable = ((Component)serializable).getParent();
                    }
                    this.containerWindow = (Container)serializable;
                    graphics = ((Component)serializable).getGraphics();
                    if (graphics == null) {
                        System.out.println("GL4Java-MSJVM: got empty Graphics");
                    }
                    this.pData = winHandleAccess.getWinHandle((Component)serializable, graphics);
                    if (this.pData != 0L) {
                        Object object;
                        Point point;
                        try {
                            point = this._comp.getLocationOnScreen();
                        }
                        catch (Exception exception) {
                            point = this._comp.getLocation();
                            object = this.containerWindow.getLocation();
                            point.x += ((Point)object).x;
                            point.y += ((Point)object).y;
                            Insets insets = this.containerWindow.getInsets();
                            point.x += insets.left;
                            point.y += insets.top;
                        }
                        Rectangle rectangle = this._comp.getBounds();
                        this.createwinx = point.x;
                        this.createwiny = point.y;
                        this.createwinw = rectangle.width;
                        this.createwinh = rectangle.height;
                        this.windowHandle = 0L;
                        this.threadRunning = true;
                        this.destroyWindow = false;
                        object = new Thread(this);
                        ((Thread)object).start();
                        while (this.windowHandle == 0L && this.threadRunning) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                } else if (osType == -1 && !this.useJAWT()) {
                    winHandleAccess = (WinHandleAccess)Class.forName(string + "windows.Win32HandleAccess").newInstance();
                    this.windowHandle = this.pData = winHandleAccess.getWinHandle(this._compHeavy, graphics);
                } else if (!(osType != 2 && osType != 3 || this.useJAWT())) {
                    winHandleAccess = (WinHandleAccess)Class.forName(string + "macintosh.MacHandleAccess").newInstance();
                    this.windowHandle = this.pData = winHandleAccess.getWinHandle(this._compHeavy, graphics);
                } else if (!this.useJAWT()) {
                    winHandleAccess = (WinHandleAccess)Class.forName(string + "motif.X11HandleAccess").newInstance();
                    this.windowHandle = this.pData = winHandleAccess.getWinHandle(this._compHeavy, graphics);
                }
            }
            if (this.offScrnSize != null) {
                this.createwinw = this.offScrnSize.width;
                this.createwinh = this.offScrnSize.height;
            } else {
                serializable = this._comp.getBounds();
                this.createwinw = ((Rectangle)serializable).width;
                this.createwinh = ((Rectangle)serializable).height;
            }
            try {
                this.gljInit();
            }
            catch (GL4JavaInitException gL4JavaInitException) {
                System.out.println("can't create a GL context\n");
            }
        }
        catch (Exception exception) {
            System.out.println("An exception is thrown, while creating a GL context\n");
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    protected final synchronized void gljInit() throws GL4JavaInitException {
        boolean bl;
        if (!libsLoaded) {
            return;
        }
        if (this.glCaps == null) {
            System.out.println("Internal error: glCaps not initialized !!");
            throw new GL4JavaInitException();
        }
        if (this.pData == 0L && !this.offScreenRenderer && !this.useJAWT()) {
            System.out.println("could not open a GL widget -- Win CONTEXT");
            throw new GL4JavaInitException();
        }
        if (gljClassDebug) {
            System.out.println("GLContext gljInit");
        }
        if (!(bl = this.openOpenGLNative(this._comp))) {
            if (useMSJDirect) {
                this.destroyWindow = true;
                while (this.threadRunning) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.pData = 0L;
                this.windowHandle = 0L;
            }
            System.out.println("could not open a GL widget -- GL CONTEXT");
            throw new GL4JavaInitException();
        }
        this.isInitialized = true;
        this.glEnabled = true;
        ++glContextNumber;
    }

    public void run() {
        if (!useMSJDirect) {
            System.err.println("GL4Java-MSJVM-Run: INTERNAL ERROR");
            System.exit(0);
        }
        this.pData = GljMSJDirect.createOGLWindowNative(this.pData, this.createwinx, this.createwiny, this.createwinw, this.createwinh);
        if (this.pData != 0L) {
            this.windowHandle = this.pData;
            while (!this.destroyWindow) {
                GljMSJDirect.OGLWindowMsgPump();
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.destroyWindow = false;
            GljMSJDirect.destroyOGLWindowNative(this.windowHandle);
            this.windowHandle = 0L;
            this.pData = 0L;
            GljMSJDirect.OGLWindowMsgPump();
        }
        this.threadRunning = false;
    }

    public final boolean gljIsInit() {
        return this.isInitialized;
    }

    public final void gljResize(int n, int n2) {
        if (!this.isInitialized || !this.glEnabled) {
            return;
        }
        if (this.offScreenRenderer) {
            return;
        }
        if (useMSJDirect) {
            try {
                Point point = this._comp.getLocationOnScreen();
                GljMSJDirect.moveOGLWindowNative(this.windowHandle, point.x, point.y, n, n2);
            }
            catch (Exception exception) {}
        } else {
            this.gljResizeNative(this.createOwnWindow, this.displayHandle, this.windowHandle, n, n2);
        }
    }

    private final native void gljResizeNative(boolean var1, long var2, long var4, int var6, int var7);

    protected final native boolean useJAWT();

    protected final native boolean hasJAWTSurfaceChanged(long var1);

    protected final native boolean openOpenGLNative(Component var1);

    public static final boolean gljCheckGLTypes() {
        return GLContext.gljCheckGLTypesNative();
    }

    private static final native boolean gljCheckGLTypesNative();

    public final boolean gljCheckGL() {
        if (!this.isInitialized || !this.glEnabled) {
            return false;
        }
        int n = this.gl.glGetError();
        if (n != 0) {
            String string = this.glu.gluErrorString(n);
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                System.out.println("GL ERROR : " + string);
                System.out.println("GL ERROR : " + n + " == 0x" + Integer.toHexString(n));
                exception.printStackTrace();
                System.out.println();
                System.out.flush();
                return false;
            }
        }
        return true;
    }

    public final synchronized boolean gljIsCurrent() {
        if (!this.isInitialized || !this.glEnabled) {
            return false;
        }
        Thread thread = Thread.currentThread();
        return this.ctxThread == thread && this.glContext == GLContext.gljGetCurrentContext();
    }

    public final synchronized boolean gljIsRequested() {
        if (!this.isInitialized || !this.glEnabled) {
            return false;
        }
        Thread thread = Thread.currentThread();
        return this.nextThread != null && this.nextThread != thread;
    }

    public final synchronized boolean gljMakeCurrent() {
        if (!this.isInitialized || !this.glEnabled) {
            return false;
        }
        Thread thread = Thread.currentThread();
        boolean bl = false;
        while (this.nextThread != null && this.nextThread != thread) {
            if (gljThreadDebug && !bl) {
                System.out.println("wait-switch: " + thread);
                System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
            }
            if (this.ctxThread == thread) {
                if (gljThreadDebug && !bl) {
                    System.out.println("wait-current: " + thread + " for earmarked: " + this.nextThread);
                    System.out.println("\tfreeing context force .. ctxThread=" + this.ctxThread);
                }
                this.gljFree(true);
            }
            bl = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        bl = false;
        while (this.ctxThread != null && this.ctxThread != thread) {
            this.nextThread = thread;
            if (gljThreadDebug && !bl) {
                System.out.println("wait-earmarked: " + thread);
                System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
                bl = true;
            }
            if (this._comp instanceof GLRunnable && ((GLRunnable)((Object)this._comp)).ownsThread(this.ctxThread)) {
                Component component = this._comp;
                synchronized (component) {
                    ((GLRunnable)((Object)this._comp)).freeGLContext();
                    ((GLRunnable)((Object)this._comp)).notifyAll();
                }
                this.notifyAll();
                if (gljThreadDebug) {
                    System.out.println("\tfreeGLContext -> " + this.ctxThread);
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean bl2 = false;
        if (this.gljIsCurrent()) {
            bl2 = GLContext.lockJAWT(this._comp, this.windowHandle, gljThreadDebug);
            if (gljThreadDebug) {
                System.out.println("MakeCurrent: " + thread + " no CTX change, allready own, lockJAWT: " + bl2);
            }
            return bl2;
        }
        if (this.ctxThread != null && this.ctxThread != thread) {
            System.out.println("MakeCurrent: ctxThread ain't zero, funny failure");
            System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
            return bl2;
        }
        this.ctxThread = thread;
        if (gljThreadDebug) {
            if (this.nextThread == thread) {
                System.out.println("MakeCurrent: " + thread + " <EarMarked Run>");
            } else {
                System.out.println("MakeCurrent: " + thread + " <New>");
            }
            System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
        }
        if (this.nextThread == thread) {
            this.nextThread = null;
        }
        if (!(bl2 = GLContext.gljMakeCurrentNative(this._comp, this.displayHandle, this.windowHandle, this.glContext))) {
            if (gljThreadDebug) {
                System.out.println("Native MakeCurrent failed");
                System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
                Exception exception = new Exception();
                exception.printStackTrace();
            }
            if (this.hasJAWTSurfaceChanged(this.windowHandle)) {
                System.out.println("GL4Java: JAWT Surface-Change !!!");
                System.out.println("\t destroying GLContext ...!!!");
                this.gljDestroy();
                System.out.println("GL4Java: JAWT Surface-Change !!!");
                System.out.println("\t creating GLContext ...!!!");
                try {
                    System.out.println("GL4Java: JAWT Surface-Change !!!");
                    this.gljInit();
                    System.out.println("GL4Java: JAWT Surface-Change finished !!!");
                }
                catch (GL4JavaInitException gL4JavaInitException) {
                    System.out.println("\tcan't create a GL context\n");
                    System.out.println("GL4Java: JAWT Surface Change FAILED!!!");
                }
                System.out.println("\t GLContext Recreated ...!!!");
            }
        }
        this.notifyAll();
        return bl2;
    }

    public final boolean gljMakeCurrent(boolean bl) {
        return this.gljMakeCurrent();
    }

    private static final native boolean gljMakeCurrentNative(Component var0, long var1, long var3, long var5);

    private static final native boolean lockJAWT(Component var0, long var1, boolean var3);

    public static final native long gljGetCurrentContext();

    public final synchronized boolean gljDestroy() {
        if (!this.isInitialized) {
            return false;
        }
        boolean bl = true;
        if (!this.gljDestroyNative(this._comp)) {
            bl = false;
        }
        this.windowHandle = 0L;
        this.glContext = 0L;
        this.pixmapHandle = 0L;
        if (useMSJDirect) {
            this.destroyWindow = false;
            GljMSJDirect.destroyOGLWindowNative(this.pData);
            this.windowHandle = 0L;
            GljMSJDirect.OGLWindowMsgPump();
        }
        this.pData = 0L;
        this.isInitialized = false;
        --glContextNumber;
        if (gljClassDebug) {
            System.out.println("GLContext destroyed (remaining ctx=" + glContextNumber + ")");
        }
        return bl;
    }

    private final native boolean gljDestroyNative(Component var1);

    public final boolean gljFree() {
        return this.gljFree(false);
    }

    public final synchronized boolean gljFree(boolean bl) {
        if (!this.isInitialized) {
            return false;
        }
        boolean bl2 = true;
        Thread thread = Thread.currentThread();
        if (this.ctxThread != thread) {
            if (gljThreadDebug) {
                System.out.println("gljFree: denied, not holding context ! ");
                System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
                Exception exception = new Exception();
                exception.printStackTrace();
            }
            return true;
        }
        if (!(this._comp instanceof GLRunnable) || !((GLRunnable)((Object)this._comp)).ownsThread(thread)) {
            bl = true;
        }
        if (bl || this.nextThread != null && this.nextThread != thread) {
            bl2 = GLContext.gljFreeNative(this._comp, this.displayHandle, this.windowHandle, this.glContext);
            this.ctxThread = null;
            if (gljThreadDebug) {
                System.out.println("gljFree: gljFreeNative result: " + bl2);
                System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
            }
        } else {
            bl2 = GLContext.unlockJAWT(this.windowHandle, false);
            if (gljThreadDebug) {
                System.out.println("gljFree: no CTX change, no requests, unlockJAWT: " + bl2);
                System.out.println("\tctxstate thisThread=" + thread + ", ctxThread=" + this.ctxThread + ", nextThread=" + this.nextThread + ", thisContext=" + this.glContext + ", currentContext=" + GLContext.gljGetCurrentContext());
            }
        }
        this.notifyAll();
        return bl2;
    }

    private static final native boolean gljFreeNative(Component var0, long var1, long var3, long var5);

    private static final native boolean unlockJAWT(long var0, boolean var2);

    public final boolean gljSwap() {
        if (!this.isInitialized || !this.glEnabled) {
            return false;
        }
        return GLContext.gljSwapNative(this.displayHandle, this.windowHandle, this.glContext, this.glCaps.getDoubleBuffered());
    }

    private static final native boolean gljSwapNative(long var0, long var2, long var4, boolean var6);

    public void setEnabled(boolean bl) {
        this.glEnabled = bl;
        if (!bl && this.isInitialized) {
            this.gljFree();
        }
    }

    public boolean isEnabled() {
        return this.glEnabled;
    }

    public static final native boolean gljFetchOSGLFunctions(String var0, String var1, boolean var2);

    public static final native boolean gljFetchGLFunctions(String var0, String var1, boolean var2);

    public static final native boolean gljTestGLProc(String var0, boolean var1);

    public static final native void gljReadPixelGL2AWT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int[] var10);

    public static final native void gljReadPixelGL2AWT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, short[] var10);

    public static final native void gljReadPixelGL2AWT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10);

    public static final String gljGetNativeLibVendor() {
        return GLContext.gljGetNativeLibVendorNative();
    }

    private static final native String gljGetNativeLibVendorNative();

    public static final String gljGetNativeLibVersion() {
        return GLContext.gljGetNativeLibVersionNative();
    }

    private static final native String gljGetNativeLibVersionNative();

    public static final String gljGetClassVersion() {
        return version;
    }

    public static final String gljGetClassVendor() {
        return "Jausoft - Sven Goethel Software Development";
    }

    public final String gljGetVersions() {
        return this.gljGetVersions(false);
    }

    public final String gljGetVersions(boolean bl) {
        if (!libsLoaded || this.gl == null || this.glu == null || !this.gljIsInit()) {
            return null;
        }
        String string = "Java Virtual Machine: Version " + GLContext.getJVMVersion() + " (" + GLContext.getJVMVersionMajor() + "." + GLContext.getJVMVersionMinor() + ")" + ", Vendor: " + GLContext.getJVMVendor() + "\n";
        GLF gLF = new GLF();
        String string2 = "GL4Java - LGPL-Version\n-------------------------------------------------\n-------------------------------------------------\nJava-Class         : GL4Java.GLContext           \n          : Version: " + GLContext.gljGetClassVersion() + "\n" + "            Vendor : " + GLContext.gljGetClassVendor() + "\n" + "Native-Library     : GL4Java.GLContext           \n" + "            Version: " + GLContext.gljGetNativeLibVersion() + "\n" + "            Vendor : " + GLContext.gljGetNativeLibVendor() + "\n" + "-------------------------------------------------\n" + "Java-Class         : GL4Java.GLFunc impl.        \n" + "          : Version: " + this.gl.getClassVersion() + "\n" + "            Vendor : " + this.gl.getClassVendor() + "\n" + "Native-Library     : GL4Java.GLFunc impl.        \n" + "            Version: " + this.gl.getNativeVersion() + "\n" + "            Vendor : " + this.gl.getNativeVendor() + "\n" + "-------------------------------------------------\n" + "Java-Class         : GL4Java.GLUFunc impl.       \n" + "          : Version: " + this.glu.getClassVersion() + "\n" + "            Vendor : " + this.glu.getClassVendor() + "\n" + "Native-Library     : GL4Java.GLUFunc impl.       \n" + "            Version: " + this.glu.getNativeVersion() + "\n" + "            Vendor : " + this.glu.getNativeVendor() + "\n" + "-------------------------------------------------\n" + "Java-Class         : GL4Java.utils.glf.GLFFuncJNI  \n" + "          : Version: " + gLF.getClassVersion() + "\n" + "            Vendor : " + gLF.getClassVendor() + "\n" + "Native-Library     : GL4Javautils.glf..GLFFuncJNI  \n" + "            Version: " + gLF.getNativeVersion() + "\n" + "            Vendor : " + gLF.getNativeVendor() + "\n" + "-------------------------------------------------\n" + "\n" + string + "\n";
        String string3 = this.gl.glGetString(7936);
        String string4 = this.gl.glGetString(7937);
        String string5 = this.gl.glGetString(7938);
        String string6 = this.gl.glGetString(7939);
        String string7 = this.glu.gluGetString(100800);
        String string8 = this.glu.gluGetString(100801);
        String string9 = "OpenGL - Versions                              \n-----------------------------------------------\nGL  VENDOR: " + string3 + "\n" + "GL  RENDERER: " + string4 + "\n" + "GL  VERSION: " + string5 + "\n" + "GL  EXTENSIONS: " + string6 + "\n" + "GLU VERSION: " + string7 + "\n" + "GLU EXTENSIONS: " + string8 + "\n" + "\n";
        String string10 = "OpenGL - Function Test (" + GLFunc.GL_PROC_NAMES.length + " Functions)       \n" + "-----------------------------------------------\n";
        if (bl) {
            System.out.println(string2);
            System.out.println(string9);
            System.out.println(string10);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < GLFunc.GL_PROC_NAMES.length) {
            String string11;
            String string12 = GLFunc.GL_PROC_NAMES[n2];
            if (string12 == null) break;
            if (GLContext.gljTestGLProc(string12, bl)) {
                string11 = "#" + n2 + " OK   : " + string12 + "\n";
                ++n;
            } else {
                string11 = "#" + n2 + " NOPE : " + string12 + "\n";
            }
            string10 = string10 + string11;
            ++n2;
        }
        string10 = string10 + "-----------------------------------------------\n";
        string10 = string10 + "Got " + n + " / " + GLFunc.GL_PROC_NAMES.length + " Functions \n";
        string10 = string10 + "===============================================\n";
        return string2 + "\n" + string9 + "\n" + string10;
    }

    public final Frame gljShowVersions() {
        Frame frame = new Frame("GL4Java Version");
        TextArea textArea = new TextArea(25, 80);
        textArea.setEditable(false);
        frame.add(textArea);
        ((Component)frame).setSize(600, 400);
        frame.pack();
        ((Component)frame).setVisible(true);
        String string = "null string";
        if (!this.gljMakeCurrent(true)) {
            string = "problem in use() method\n";
        } else {
            string = this.gljGetVersions(gljNativeDebug);
            if (string == null) {
                string = "could not get versions";
            }
            System.out.println(string);
            this.gljFree();
        }
        textArea.append(string);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        return frame;
    }
}

