/*
 * Decompiled with CFR 0.152.
 */
package gl4java.applet;

import gl4java.GLContext;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.awt.GLAnimCanvas;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SimpleGLAnimApplet1
extends Applet
implements MouseListener,
WindowListener,
ActionListener,
ItemListener {
    public GLAnimCanvas canvas = null;
    public Button buttonInfo = null;
    public Button buttonFps = null;
    public TextField textFps = null;
    public Checkbox checkUseRepaint = null;
    public Checkbox checkUseFpsSleep = null;
    public Checkbox checkUseYield = null;
    public Button buttonReStart = null;
    Frame fInfo = null;
    Container _origCont = null;
    Frame _saveFrame = null;

    public void init() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 4));
        this.buttonInfo = new Button("GL4Java");
        panel.add(this.buttonInfo);
        this.buttonReStart = new Button("start/stop");
        panel.add(this.buttonReStart);
        this.buttonFps = new Button("fps: ");
        panel.add(this.buttonFps);
        this.textFps = new TextField("0000000000");
        panel.add(this.textFps);
        this.checkUseRepaint = new Checkbox("repaint", true);
        panel.add(this.checkUseRepaint);
        this.checkUseFpsSleep = new Checkbox("fps-sleep", true);
        panel.add(this.checkUseFpsSleep);
        this.checkUseYield = new Checkbox("yield", true);
        panel.add(this.checkUseYield);
        this.add("South", panel);
    }

    public void setCheckButtons() {
        this.checkUseFpsSleep.setState(this.canvas.getUseFpsSleep());
        this.checkUseRepaint.setState(this.canvas.getUseRepaint());
        this.checkUseYield.setState(this.canvas.getUseYield());
    }

    public void start() {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet start ..");
        }
        this.setCheckButtons();
        this.buttonInfo.addActionListener(this);
        this.checkUseRepaint.addItemListener(this);
        this.checkUseFpsSleep.addItemListener(this);
        this.checkUseYield.addItemListener(this);
        this.buttonReStart.addActionListener(this);
        this.buttonFps.addActionListener(this);
        this.canvas.addMouseListener(this);
        this.textFps.addActionListener(this);
        this.canvas.setVisible(true);
        this.canvas.repaint();
        this.canvas.start();
    }

    public void stop() {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet stop ..");
        }
        this.buttonInfo.removeActionListener(this);
        this.checkUseRepaint.removeItemListener(this);
        this.checkUseFpsSleep.removeItemListener(this);
        this.checkUseYield.removeItemListener(this);
        this.buttonReStart.removeActionListener(this);
        this.buttonFps.removeActionListener(this);
        this.canvas.removeMouseListener(this);
        this.canvas.cvsDispose();
    }

    public void destroy() {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet destroy ..");
        }
        if (this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
        this.canvas.cvsDispose();
    }

    protected void finalize() throws Throwable {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet finalize ..");
        }
        super.finalize();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2) {
            if (component instanceof GLAnimCanvas) {
                GLAnimCanvas gLAnimCanvas = (GLAnimCanvas)component;
                System.out.println("\n\nswitch requested: " + gLAnimCanvas);
                gLAnimCanvas.cvsDispose();
                System.out.println("\n\ndisposed: " + gLAnimCanvas);
                Container container = gLAnimCanvas.getParent();
                container.remove(gLAnimCanvas);
                System.out.println("\n\nremoved: " + gLAnimCanvas);
                System.out.println("Global GLAnimCanvas Render-Thread Number: " + GLAnimCanvas.getGlobalThreadNumber());
                System.out.println("GLContextNumber: " + GLContext.getNativeGLContextNumber());
                if (this._origCont != null && container == this._saveFrame) {
                    this._saveFrame.dispose();
                    this._saveFrame = null;
                    this._origCont.add(this.canvas);
                    this._origCont.doLayout();
                    this._origCont = null;
                } else if (this._saveFrame == null && this._origCont == null) {
                    this._origCont = container;
                    this._saveFrame = new Frame("EXTRA");
                    this._saveFrame.add(gLAnimCanvas);
                    this._saveFrame.pack();
                    ((Component)this._saveFrame).setVisible(true);
                }
                gLAnimCanvas.setVisible(true);
                gLAnimCanvas.repaint();
                gLAnimCanvas.start();
                System.out.println("\nadded+started: " + gLAnimCanvas);
                System.out.println("Global GLAnimCanvas Render-Thread Number: " + GLAnimCanvas.getGlobalThreadNumber());
                System.out.println("GLContextNumber: " + GLContext.getNativeGLContextNumber());
            }
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable.equals(this.checkUseRepaint) && this.canvas != null) {
            this.canvas.setUseRepaint(this.checkUseRepaint.getState());
            System.out.println("canvas uses repaint: " + this.checkUseRepaint.getState());
        }
        if (itemSelectable.equals(this.checkUseFpsSleep) && this.canvas != null) {
            this.canvas.setUseFpsSleep(this.checkUseFpsSleep.getState());
            System.out.println("canvas uses fps-sleep: " + this.checkUseFpsSleep.getState());
        }
        if (itemSelectable.equals(this.checkUseYield) && this.canvas != null) {
            this.canvas.setUseYield(this.checkUseYield.getState());
            System.out.println("canvas uses Yield " + this.checkUseYield.getState());
        }
        this.setCheckButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.textFps) {
            try {
                double d = Double.valueOf(this.textFps.getText());
                if (this.canvas != null) {
                    this.canvas.setAnimateFps(d);
                    this.canvas.setSuspended(false, true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("wrong fps format, use float ..");
            }
        } else if (this.canvas != null && object.equals(this.buttonFps)) {
            double d = 0.0;
            this.canvas.stopFpsCounter();
            d = this.canvas.getFps();
            int n = (int)(d * 100.0);
            d = (double)n / 100.0;
            this.textFps.setText(String.valueOf(d));
            this.canvas.resetFpsCounter();
        } else if (object.equals(this.buttonInfo)) {
            if (this.fInfo == null && this.canvas != null && this.canvas.getGLContext() != null) {
                this.fInfo = this.showGLInfo();
            }
        } else if (this.canvas != null && object.equals(this.buttonReStart)) {
            this.canvas.setSuspended(!this.canvas.isSuspended(), false);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public Frame showGLInfo() {
        if (this.canvas == null) {
            return null;
        }
        GLContext gLContext = this.canvas.getGLContext();
        if (gLContext == null) {
            return null;
        }
        GLFunc gLFunc = gLContext.getGLFunc();
        if (gLFunc == null) {
            return null;
        }
        GLUFunc gLUFunc = gLContext.getGLUFunc();
        if (gLFunc == null) {
            return null;
        }
        this.canvas.setSuspended(true, false);
        Frame frame = new Frame("GL4Java Version");
        TextArea textArea = new TextArea(25, 80);
        textArea.setEditable(false);
        frame.add(textArea);
        ((Component)frame).setSize(600, 400);
        String string = "null string";
        if (!gLContext.gljMakeCurrent()) {
            string = "problem in use() method\n";
        } else {
            string = this.canvas.getGLContext().gljGetVersions();
            if (string == null) {
                string = "could not get versions";
            }
            System.out.println(string);
            gLContext.gljFree();
        }
        textArea.append(string);
        frame.addWindowListener(this);
        this.canvas.setSuspended(false, false);
        frame.pack();
        ((Component)frame).setVisible(true);
        return frame;
    }
}

