/*
 * Decompiled with CFR 0.152.
 */
package gl4java.awt;

import gl4java.GLCapabilities;
import gl4java.GLContext;
import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUEnum;
import gl4java.GLUFunc;
import gl4java.drawable.GLDrawable;
import gl4java.drawable.GLEventListener;
import gl4java.drawable.utils.GLEventListenerList;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;

public class GLCanvas
extends Canvas
implements GLEnum,
GLUEnum,
ComponentListener,
WindowListener,
MouseListener,
GLDrawable {
    protected GLContext glj = null;
    public GLFunc gl = null;
    public GLUFunc glu = null;
    protected Dimension size = null;
    protected boolean mustResize = false;
    protected boolean isInit = false;
    protected boolean needCvsDispose = false;
    protected boolean doubleBuffer = true;
    protected int stencilBits = 0;
    protected int accumSize = 0;
    protected boolean stereoView = false;
    protected boolean rgba = true;
    protected GLCapabilities capabilities = null;
    protected boolean createOwnWindow = false;
    protected GLContext sharedGLContext;
    private GLEventListenerList listeners = new GLEventListenerList();
    protected Window topLevelWindow = null;
    protected long _f_dur = 0L;

    public GLCanvas(GLCapabilities gLCapabilities, int n, int n2, String string, String string2) {
        this.capabilities = gLCapabilities;
        this.gl = GLContext.createGLFunc(string);
        if (this.gl == null) {
            System.out.println("GLFunc implementation " + string + " not created");
        }
        if ((this.glu = GLContext.createGLUFunc(string2)) == null) {
            System.out.println("GLUFunc implementation " + string2 + " not created");
        }
        this.size = new Dimension(n, n2);
        this.setSize(this.size);
    }

    public GLCanvas(GLCapabilities gLCapabilities, int n, int n2) {
        this(gLCapabilities, n, n2, null, null);
    }

    public GLCanvas(int n, int n2, String string, String string2) {
        this(null, n, n2, string, string2);
    }

    public GLCanvas(int n, int n2) {
        this(n, n2, null, null);
    }

    public GLCanvas(GraphicsConfiguration graphicsConfiguration, GLCapabilities gLCapabilities, int n, int n2, String string, String string2) {
        super(graphicsConfiguration);
        this.capabilities = gLCapabilities;
        this.gl = GLContext.createGLFunc(string);
        if (this.gl == null) {
            System.out.println("GLFunc implementation " + string + " not created");
        }
        if ((this.glu = GLContext.createGLUFunc(string2)) == null) {
            System.out.println("GLUFunc implementation " + string2 + " not created");
        }
        this.size = new Dimension(n, n2);
        this.setSize(this.size);
    }

    public GLCanvas(GraphicsConfiguration graphicsConfiguration, GLCapabilities gLCapabilities, int n, int n2) {
        this(graphicsConfiguration, gLCapabilities, n, n2, null, null);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public final GLContext getGLContext() {
        return this.glj;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final Window getTopLevelWindow() {
        return this.topLevelWindow;
    }

    public final void paint(Graphics graphics) {
        if (this.glj == null || !this.glj.gljIsInit() && this.isGLEnabled()) {
            if (GLContext.gljClassDebug) {
                System.out.println("GLCanvas create GLContext (recreate=" + (this.glj != null) + ")");
            }
            this.preInit();
            if (this.glj != null) {
                this.glj = null;
            }
            this.glj = this.capabilities != null ? new GLContext((Component)this, this.gl, this.glu, this.capabilities, this.sharedGLContext) : new GLContext(this, this.gl, this.glu, this.createOwnWindow, this.doubleBuffer, this.stereoView, this.rgba, this.stencilBits, this.accumSize, this.sharedGLContext);
            if (this.glj == null) {
                return;
            }
            this.createOwnWindow = this.glj.isOwnWindowCreated();
            this.doubleBuffer = this.glj.isDoubleBuffer();
            this.stencilBits = this.glj.getStencilBitNumber();
            this.accumSize = this.glj.getAccumSize();
            this.stereoView = this.glj.isStereoView();
            this.rgba = this.glj.isRGBA();
            Color color = this.getBackground();
            this.gl.glClearColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.0f);
            this.init();
            Container container = this.getParent();
            Container container2 = null;
            while (container != null) {
                container2 = container;
                container = container.getParent();
            }
            if (container2 instanceof Window) {
                this.topLevelWindow = (Window)container2;
                this.topLevelWindow.addComponentListener(this);
            } else {
                this.topLevelWindow = null;
                System.out.println("toplevel is not a Window: " + container2);
            }
            if (this.topLevelWindow != null) {
                this.topLevelWindow.addWindowListener(this);
            } else {
                System.out.println("no parent found for " + this.getName());
                System.out.flush();
            }
            this.addComponentListener(this);
            this.addMouseListener(this);
            this.mustResize = true;
            this.isInit = true;
        }
        this.sDisplay();
    }

    public void preInit() {
    }

    public void init() {
        this.listeners.sendInitEvent(this);
    }

    public void doCleanup() {
        this.listeners.sendCleanupEvent(this);
    }

    public boolean cvsIsInit() {
        return this.isInit && this.glj != null && this.glj.gljIsInit();
    }

    public void setGLEnabled(boolean bl) {
        if (this.glj != null) {
            this.glj.setEnabled(bl);
        }
    }

    public void setVisible(boolean bl) {
        if (this.glj != null) {
            this.glj.setEnabled(bl);
        }
        super.setVisible(bl);
    }

    public boolean isGLEnabled() {
        if (this.glj != null) {
            return this.glj.isEnabled();
        }
        return false;
    }

    public long getLastFrameMillis() {
        return this._f_dur;
    }

    public final void sDisplay() {
        boolean bl = true;
        if (!this.cvsIsInit()) {
            return;
        }
        if (this.mustResize && this.glj.gljMakeCurrent()) {
            this.size = this.getSize();
            this.glj.gljResize(this.size.width, this.size.height);
            this.reshape(this.size.width, this.size.height);
            this.mustResize = false;
            this.invalidate();
            this.repaint(100L);
            this.glj.gljFree(true);
        }
        long l = System.currentTimeMillis();
        if (bl) {
            this.display();
        }
        this._f_dur = System.currentTimeMillis() - l;
    }

    public void display() {
        this.listeners.sendPreDisplayEvent(this);
        if (this.glj.gljMakeCurrent()) {
            this.listeners.sendDisplayEvent(this);
            this.glj.gljSwap();
            this.glj.gljCheckGL();
            this.glj.gljFree();
            this.listeners.sendPostDisplayEvent(this);
        }
    }

    public void reshape(int n, int n2) {
        this.gl.glViewport(0, 0, n, n2);
        this.listeners.sendReshapeEvent(this, n, n2);
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.glj != null && this.glj.gljIsInit() && componentEvent.getComponent() == this) {
            this.mustResize = true;
            this.repaint();
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (this.glj != null && this.glj.gljIsInit()) {
            this.repaint(100L);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.glj != null && this.glj.gljIsInit()) {
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getComponent().equals(this.topLevelWindow)) {
            this.cvsDispose();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.needCvsDispose) {
            this.cvsDispose();
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.glj != null && this.glj.gljIsInit()) {
            this.repaint(100L);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void cvsDispose() {
        if (GLContext.gljClassDebug) {
            System.out.println("GLCanvas cvsDispose (doit=" + (this.glj != null && this.glj.gljIsInit()) + ")");
        }
        this.isInit = false;
        this.removeComponentListener(this);
        this.removeMouseListener(this);
        if (this.glj != null && this.glj.gljIsInit()) {
            try {
                this.setVisible(false);
                this.doCleanup();
                this.glj.gljDestroy();
                this.needCvsDispose = false;
            }
            catch (Exception exception) {
                this.needCvsDispose = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (GLContext.gljClassDebug) {
            System.out.println("GLCanvas finalize ..");
        }
        this.cvsDispose();
        super.finalize();
    }

    public void destroy() {
        if (GLContext.gljClassDebug) {
            System.out.println("GLCanvas destroy ..");
        }
        this.cvsDispose();
    }

    public final int cvsGetWidth() {
        return this.getSize().width;
    }

    public final int cvsGetHeight() {
        return this.getSize().height;
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.listeners.add(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.listeners.remove(gLEventListener);
    }

    public EventListener[] getListeners(Class clazz) throws ClassCastException {
        EventListener[] eventListenerArray;
        EventListener[] eventListenerArray2 = null;
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("gl4java.drawable.GLEventListener");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (clazz2 != null && clazz.isAssignableFrom(clazz2)) {
            eventListenerArray2 = this.listeners.getListeners();
        }
        if ((eventListenerArray = super.getListeners(clazz)) == null || eventListenerArray.length == 0) {
            return eventListenerArray2;
        }
        if (eventListenerArray2 == null || eventListenerArray2.length == 0) {
            return eventListenerArray;
        }
        EventListener[] eventListenerArray3 = new EventListener[eventListenerArray.length + eventListenerArray2.length];
        try {
            System.arraycopy(eventListenerArray2, 0, eventListenerArray3, 0, eventListenerArray2.length);
            System.arraycopy(eventListenerArray, 0, eventListenerArray3, eventListenerArray2.length, eventListenerArray.length);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        eventListenerArray2 = null;
        eventListenerArray = null;
        return eventListenerArray3;
    }

    public GLFunc getGL() {
        return this.gl;
    }

    public GLUFunc getGLU() {
        return this.glu;
    }

    static {
        if (!GLContext.doLoadNativeLibraries(null, null, null)) {
            System.out.println("GLCanvas could not load def. native libs.");
        }
    }
}

