/*
 * Decompiled with CFR 0.152.
 */
package gl4java.drawable.utils;

import gl4java.drawable.GLDrawable;
import gl4java.drawable.GLEventListener;
import java.util.EventListener;

public class GLEventListenerList {
    private GLEventListener[] data = new GLEventListener[2];
    private int nextFreeIdx = 0;

    public void add(GLEventListener gLEventListener) {
        if (this.nextFreeIdx == this.data.length) {
            this.grow();
        }
        this.data[this.nextFreeIdx++] = gLEventListener;
    }

    public void remove(GLEventListener gLEventListener) {
        int n = 0;
        while (n < this.nextFreeIdx) {
            if (this.data[n] == gLEventListener) {
                int n2 = n;
                while (n2 < this.nextFreeIdx - 1) {
                    this.data[n2] = this.data[n2 + 1];
                    ++n2;
                }
                this.data[this.nextFreeIdx - 1] = null;
                --this.nextFreeIdx;
                return;
            }
            ++n;
        }
    }

    public void sendInitEvent(GLDrawable gLDrawable) {
        int n = 0;
        while (n < this.nextFreeIdx) {
            this.data[n].init(gLDrawable);
            ++n;
        }
    }

    public void sendPreDisplayEvent(GLDrawable gLDrawable) {
        int n = 0;
        while (n < this.nextFreeIdx) {
            this.data[n].preDisplay(gLDrawable);
            ++n;
        }
    }

    public void sendDisplayEvent(GLDrawable gLDrawable) {
        int n = 0;
        while (n < this.nextFreeIdx) {
            this.data[n].display(gLDrawable);
            ++n;
        }
    }

    public void sendPostDisplayEvent(GLDrawable gLDrawable) {
        int n = 0;
        while (n < this.nextFreeIdx) {
            this.data[n].postDisplay(gLDrawable);
            ++n;
        }
    }

    public void sendCleanupEvent(GLDrawable gLDrawable) {
        int n = 0;
        while (n < this.nextFreeIdx) {
            this.data[n].cleanup(gLDrawable);
            ++n;
        }
    }

    public void sendReshapeEvent(GLDrawable gLDrawable, int n, int n2) {
        int n3 = 0;
        while (n3 < this.nextFreeIdx) {
            this.data[n3].reshape(gLDrawable, n, n2);
            ++n3;
        }
    }

    public EventListener[] getListeners() {
        EventListener[] eventListenerArray = new GLEventListener[this.nextFreeIdx];
        System.arraycopy(this.data, 0, eventListenerArray, 0, this.nextFreeIdx);
        return eventListenerArray;
    }

    public int size() {
        return this.nextFreeIdx;
    }

    private void grow() {
        GLEventListener[] gLEventListenerArray = new GLEventListener[2 * this.data.length];
        System.arraycopy(this.data, 0, gLEventListenerArray, 0, this.data.length);
        this.data = gLEventListenerArray;
    }
}

