/*
 * Decompiled with CFR 0.152.
 */
package gl4java.swing;

import gl4java.GLCapabilities;
import gl4java.GLContext;
import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUEnum;
import gl4java.GLUFunc;
import gl4java.drawable.GLDrawable;
import gl4java.drawable.GLEventListener;
import gl4java.drawable.utils.GLEventListenerList;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class GLJPanel
extends JPanel
implements GLEnum,
GLUEnum,
ComponentListener,
WindowListener,
MouseListener,
GLDrawable {
    protected GLContext glj = null;
    public GLFunc gl = null;
    public GLUFunc glu = null;
    protected boolean mustResize = false;
    protected boolean cvsInitialized = false;
    protected boolean needCvsDispose = false;
    protected int stencilBits = 0;
    protected int accumSize = 0;
    protected boolean stereoView = false;
    protected boolean rgba = true;
    protected GLContext sharedGLContext;
    protected BufferedImage offImage = null;
    protected int glFormat = 0;
    protected int glType = 0;
    protected int glComps = 0;
    protected int awtFormat = 0;
    protected Dimension offScrnSize = null;
    protected boolean customOffScrnSize = false;
    protected boolean offScrnSizeChanged = false;
    private GLEventListenerList listeners = new GLEventListenerList();
    protected Window topLevelWindow = null;
    Graphics gr = null;
    DataBufferInt dbInt = null;
    DataBufferUShort dbUShort = null;
    DataBufferByte dbByte = null;
    protected long _f_dur_self = 0L;
    protected long _f_dur_self_sum = 0L;
    protected long _f_dur_tst_sum = 0L;
    protected long _f_dur_total = 0L;
    protected long _f_dur_total_sum = 0L;
    protected int _f_dur_times = 0;

    public GLJPanel(String string, String string2, LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.gl = GLContext.createGLFunc(string);
        if (this.gl == null) {
            System.out.println("GLFunc implementation " + string + " not created");
        }
        if ((this.glu = GLContext.createGLUFunc(string2)) == null) {
            System.out.println("GLUFunc implementation " + string2 + " not created");
        }
        this.addComponentListener(this);
        this.setOpaque(true);
    }

    public GLJPanel(LayoutManager layoutManager, boolean bl) {
        this(null, null, layoutManager, bl);
    }

    public GLJPanel(boolean bl) {
        this(null, null, new FlowLayout(), bl);
    }

    public GLJPanel(LayoutManager layoutManager) {
        this(null, null, layoutManager, true);
    }

    public GLJPanel() {
        this(null, null, new FlowLayout(), true);
    }

    public final GLContext getGLContext() {
        return this.glj;
    }

    public final Window getTopLevelWindow() {
        return this.topLevelWindow;
    }

    public Dimension getOffScreenSize() {
        return this.offScrnSize;
    }

    public void setOffScreenSize(Dimension dimension) {
        if (dimension != null && !dimension.equals(this.offScrnSize) || dimension != this.offScrnSize) {
            this.offScrnSizeChanged = true;
            this.offScrnSize = dimension;
            this.customOffScrnSize = this.offScrnSize != null;
        }
    }

    public final synchronized void paintComponent(Graphics graphics) {
        if (this.glj == null || this.mustResize && !this.customOffScrnSize || this.offScrnSizeChanged) {
            if (this.mustResize) {
                this.cvsDispose();
            }
            this.preInit();
            this.glj = GLContext.createOffScreenCtx(this, this.gl, this.glu, this.stereoView, this.rgba, this.stencilBits, this.accumSize, this.sharedGLContext, this.offScrnSize);
            if (this.glj != null) {
                this.stencilBits = this.glj.getStencilBitNumber();
                this.accumSize = this.glj.getAccumSize();
                this.stereoView = this.glj.isStereoView();
                this.rgba = this.glj.isRGBA();
            }
            if (this.offImage != null) {
                this.offImage.flush();
            }
            this.offImage = null;
            this.offScrnSizeChanged = false;
            Color color = this.getBackground();
            this.gl.glClearColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.0f);
            this.init();
            Dimension dimension = this.getSize();
            this.reshape(dimension.width, dimension.height);
            Container container = this.getParent();
            Container container2 = null;
            while (container != null) {
                container2 = container;
                container = container.getParent();
            }
            if (container2 instanceof Window) {
                this.topLevelWindow = (Window)container2;
                this.topLevelWindow.addComponentListener(this);
                this.topLevelWindow.addMouseListener(this);
            } else {
                this.topLevelWindow = null;
                System.out.println("toplevel is not a Window: " + container2);
            }
            if (this.topLevelWindow != null) {
                this.topLevelWindow.addWindowListener(this);
            } else {
                System.out.println("no parent found for " + this.getName());
                System.out.flush();
            }
            if (this.glj != null && this.glj.gljIsInit()) {
                this.cvsInitialized = true;
            }
        }
        this.gr = graphics;
        this.sDisplay();
    }

    public final synchronized void sDisplay() {
        Dimension dimension;
        boolean bl = true;
        long l = System.currentTimeMillis();
        if (!this.cvsIsInit()) {
            return;
        }
        this.listeners.sendPreDisplayEvent(this);
        if (!this.glj.gljMakeCurrent()) {
            System.out.println("GLJPanel: problem in use() method");
            return;
        }
        if (this.mustResize) {
            this.mustResize = false;
            dimension = null;
            dimension = this.customOffScrnSize ? this.offScrnSize : this.getSize();
            this.reshape(dimension.width, dimension.height);
        }
        if (bl) {
            this.display();
            this._f_dur_self = System.currentTimeMillis() - l;
            if (GLContext.gljClassDebug) {
                this._f_dur_self_sum += this._f_dur_self;
                this.glj.gljCheckGL();
            }
            dimension = null;
            dimension = this.customOffScrnSize ? this.offScrnSize : this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            long l2 = System.currentTimeMillis();
            if (this.offImage == null || this.offImage.getHeight() != n2 || this.offImage.getWidth() != n) {
                GLCapabilities gLCapabilities = this.glj.getGLCapabilities();
                this.awtFormat = gLCapabilities.getAlphaBits() > 0 ? 6 : 5;
                if (this.offImage != null) {
                    this.offImage.flush();
                }
                this.offImage = new BufferedImage(n, n2, this.awtFormat);
                this.dbByte = null;
                this.dbUShort = null;
                this.dbInt = null;
                switch (this.awtFormat) {
                    case 5: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=3BYTE_BGR, gl=BGR,UNSIGNED_BYTE");
                        }
                        this.glFormat = 32992;
                        this.glType = 5121;
                        this.glComps = 3;
                        this.dbByte = (DataBufferByte)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 6: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=4BYTE_ABGR, gl=BGRA,UNSIGNED_INT_8_8_8_8");
                        }
                        this.glFormat = 32993;
                        this.glType = 32821;
                        this.glComps = 4;
                        this.dbByte = (DataBufferByte)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 1: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=INT_RGB, gl=BGRA,UNSIGNED_INT_8_8_8_8_REV");
                        }
                        this.glFormat = 32993;
                        this.glType = 33639;
                        this.glComps = 4;
                        this.dbInt = (DataBufferInt)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 2: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=INT_ARGB, gl=BGRA,INT_8_8_8_8_REV");
                        }
                        this.glFormat = 32993;
                        this.glType = 33639;
                        this.glComps = 4;
                        this.dbInt = (DataBufferInt)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 4: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=INT_BGR, gl=BGRA,UNSIGNED_INT_8_8_8_8");
                        }
                        this.glFormat = 32993;
                        this.glType = 32821;
                        this.glComps = 4;
                        this.dbInt = (DataBufferInt)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 9: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=USHORT_555_RGB, gl=RGBA,UNSIGNED_INT_5_5_5_1");
                        }
                        this.glFormat = 6408;
                        this.glType = 32820;
                        this.glComps = 2;
                        this.dbUShort = (DataBufferUShort)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 8: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=USHORT_565_RGB, gl=RGB,UNSIGNED_INT_5_6_5");
                        }
                        this.glFormat = 6407;
                        this.glType = 33635;
                        this.glComps = 2;
                        this.dbUShort = (DataBufferUShort)this.offImage.getRaster().getDataBuffer();
                    }
                }
            }
            if (this.dbByte != null) {
                GLContext.gljReadPixelGL2AWT(n, 0, 0, 0, 0, n, n2, this.glFormat, this.glType, this.glj.isDoubleBuffer() ? 1029 : 1028, this.dbByte.getData());
            } else if (this.dbUShort != null) {
                GLContext.gljReadPixelGL2AWT(n, 0, 0, 0, 0, n, n2, this.glFormat, this.glType, this.glj.isDoubleBuffer() ? 1029 : 1028, this.dbUShort.getData());
            } else if (this.dbInt != null) {
                GLContext.gljReadPixelGL2AWT(n, 0, 0, 0, 0, n, n2, this.glFormat, this.glType, this.glj.isDoubleBuffer() ? 1029 : 1028, this.dbInt.getData());
            }
            if (GLContext.gljClassDebug) {
                this._f_dur_tst_sum += System.currentTimeMillis() - l2;
            }
            if (GLContext.gljClassDebug) {
                this.glj.gljCheckGL();
            }
            this.glj.gljFree();
            if (!this.customOffScrnSize) {
                this.gr.drawImage(this.offImage, 0, 0, this);
            } else {
                dimension = super.getSize();
                this.gr.drawImage(this.offImage, 0, 0, dimension.width, dimension.height, this);
            }
            this._f_dur_total = System.currentTimeMillis() - l;
            if (GLContext.gljClassDebug) {
                this._f_dur_total_sum += this._f_dur_total;
                if (++this._f_dur_times == 100) {
                    System.out.println("self p 100: " + (double)(this._f_dur_self_sum / 100L) / 1000.0 + " s");
                    System.out.println("tst p 100: " + (double)(this._f_dur_tst_sum / 100L) / 1000.0 + " s");
                    System.out.println("gl-bitblit p 100: " + (double)((this._f_dur_total_sum - this._f_dur_self_sum) / 100L) / 1000.0 + " s");
                    System.out.println("total p 100: " + (double)(this._f_dur_total_sum / 100L) / 1000.0 + " s");
                    this._f_dur_self_sum = 0L;
                    this._f_dur_tst_sum = 0L;
                    this._f_dur_total_sum = 0L;
                    this._f_dur_times = 0;
                }
            }
        }
        this.listeners.sendPostDisplayEvent(this);
    }

    public void display() {
        this.listeners.sendDisplayEvent(this);
    }

    public void preInit() {
    }

    public void init() {
        this.listeners.sendInitEvent(this);
    }

    public void doCleanup() {
        this.listeners.sendCleanupEvent(this);
    }

    public boolean cvsIsInit() {
        return this.cvsInitialized;
    }

    public void reshape(int n, int n2) {
        if (GLContext.gljClassDebug) {
            System.out.println("GLJPanel::reshape bounds(" + this.getBounds() + ")");
        }
        this.gl.glViewport(0, 0, n, n2);
        this.listeners.sendReshapeEvent(this, n, n2);
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (GLContext.gljClassDebug) {
            System.out.println("GLJPanel::componentResized(" + componentEvent.getComponent() + ")");
        }
        if (this.glj != null && this.glj.gljIsInit() && componentEvent.getComponent() == this) {
            this.mustResize = true;
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getComponent().equals(this.topLevelWindow)) {
            this.cvsDispose();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.needCvsDispose) {
            this.cvsDispose();
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void cvsDispose() {
        this.cvsInitialized = false;
        if (this.glj != null && this.glj.gljIsInit()) {
            try {
                this.glj.gljFree();
                this.doCleanup();
                this.glj.setEnabled(false);
                this.glj.gljDestroy();
                this.needCvsDispose = false;
            }
            catch (Exception exception) {
                this.needCvsDispose = true;
            }
        }
    }

    public Dimension getSize() {
        if (this.customOffScrnSize) {
            return this.offScrnSize;
        }
        return super.getSize();
    }

    public final int cvsGetWidth() {
        return this.getSize().width;
    }

    public final int cvsGetHeight() {
        return this.getSize().height;
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.listeners.add(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.listeners.remove(gLEventListener);
    }

    public GLFunc getGL() {
        return this.gl;
    }

    public GLUFunc getGLU() {
        return this.glu;
    }

    public Point getAbsoluteCoord(JRootPane jRootPane) {
        Container container = this;
        Container container2 = container.getParent();
        Point point = this.getLocation();
        Point point2 = null;
        while (container2 instanceof JComponent) {
            container = container2;
            if ((container2 = container.getParent()) instanceof JComponent) {
                point2 = container.getLocation();
                point.x += point2.x;
                point.y += point2.y;
            }
            if (container == jRootPane) break;
        }
        return point;
    }

    static {
        if (!GLContext.doLoadNativeLibraries(null, null, null)) {
            System.out.println("GLJPanel could not load def. native libs.");
        }
    }
}

