/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.VoidType;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.ArrayReferenceImpl;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.BooleanTypeImpl;
import com.sun.tools.jdi.BooleanValueImpl;
import com.sun.tools.jdi.ByteTypeImpl;
import com.sun.tools.jdi.ByteValueImpl;
import com.sun.tools.jdi.CharTypeImpl;
import com.sun.tools.jdi.CharValueImpl;
import com.sun.tools.jdi.ClassLoaderReferenceImpl;
import com.sun.tools.jdi.ClassObjectReferenceImpl;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.DoubleTypeImpl;
import com.sun.tools.jdi.DoubleValueImpl;
import com.sun.tools.jdi.EventQueueImpl;
import com.sun.tools.jdi.EventRequestManagerImpl;
import com.sun.tools.jdi.FloatTypeImpl;
import com.sun.tools.jdi.FloatValueImpl;
import com.sun.tools.jdi.IntegerTypeImpl;
import com.sun.tools.jdi.IntegerValueImpl;
import com.sun.tools.jdi.InterfaceTypeImpl;
import com.sun.tools.jdi.InternalEventHandler;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.LongTypeImpl;
import com.sun.tools.jdi.LongValueImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.Packet;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ShortTypeImpl;
import com.sun.tools.jdi.ShortValueImpl;
import com.sun.tools.jdi.StringReferenceImpl;
import com.sun.tools.jdi.TargetVM;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadGroupReferenceImpl;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VMState;
import com.sun.tools.jdi.VirtualMachineManagerImpl;
import com.sun.tools.jdi.VoidTypeImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class VirtualMachineImpl
extends MirrorImpl
implements PathSearchingVirtualMachine,
ThreadListener {
    public final int sizeofFieldRef;
    public final int sizeofMethodRef;
    public final int sizeofObjectRef;
    public final int sizeofClassRef;
    public final int sizeofFrameRef;
    private final TargetVM target;
    private final EventQueueImpl eventQueue;
    private final EventRequestManagerImpl eventRequestManager;
    private final VirtualMachineManager manager;
    int traceFlags = 0;
    static int TRACE_RAW_SENDS = 0x1000000;
    static int TRACE_RAW_RECEIVES = 0x2000000;
    boolean traceReceives = false;
    private Map typesByID;
    private TreeSet typesBySignature;
    private boolean retrievedAllTypes = false;
    private final Map objectsByID = new HashMap();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private static final int DISPOSE_THRESHOLD = 50;
    private final List batchedDisposeRequests = Collections.synchronizedList(new ArrayList(60));
    private JDWP.VirtualMachine.Version versionInfo;
    private JDWP.VirtualMachine.ClassPaths pathInfo;
    private JDWP.VirtualMachine.Capabilities capabilities = null;
    private BooleanType theBooleanType;
    private ByteType theByteType;
    private CharType theCharType;
    private ShortType theShortType;
    private IntegerType theIntegerType;
    private LongType theLongType;
    private FloatType theFloatType;
    private DoubleType theDoubleType;
    private VoidType theVoidType;
    private Process process;
    private VMState state = new VMState(this);
    private Object initMonitor = new Object();
    private boolean initComplete = false;
    private boolean shutdown = false;

    private void notifyInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            this.initComplete = true;
            this.initMonitor.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            while (!this.initComplete) {
                try {
                    this.initMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    VMState state() {
        return this.state;
    }

    public boolean threadResumable(ThreadAction threadAction) {
        this.state.thaw();
        return true;
    }

    VirtualMachineImpl(VirtualMachineManager virtualMachineManager, ConnectionService connectionService, Process process) {
        super(null);
        JDWP.VirtualMachine.IDSizes iDSizes;
        this.vm = this;
        this.manager = virtualMachineManager;
        this.process = process;
        this.target = new TargetVM(this, connectionService);
        EventQueueImpl eventQueueImpl = new EventQueueImpl(this, this.target);
        new InternalEventHandler(this, eventQueueImpl);
        this.eventQueue = new EventQueueImpl(this, this.target);
        this.eventRequestManager = new EventRequestManagerImpl(this);
        this.target.start();
        try {
            iDSizes = JDWP.VirtualMachine.IDSizes.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.sizeofFieldRef = iDSizes.fieldIDSize;
        this.sizeofMethodRef = iDSizes.methodIDSize;
        this.sizeofObjectRef = iDSizes.objectIDSize;
        this.sizeofClassRef = iDSizes.referenceTypeIDSize;
        this.sizeofFrameRef = iDSizes.frameIDSize;
        EventRequestManagerImpl eventRequestManagerImpl = new EventRequestManagerImpl(this);
        EventRequest eventRequest = eventRequestManagerImpl.createClassPrepareRequest();
        eventRequest.setSuspendPolicy(0);
        eventRequest.enable();
        eventRequest = eventRequestManagerImpl.createClassUnloadRequest();
        eventRequest.setSuspendPolicy(0);
        eventRequest.enable();
        this.notifyInitCompletion();
    }

    void validateVM() {
        if (this.shutdown) {
            throw new VMDisconnectedException();
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public List classesByName(String string) {
        this.validateVM();
        String string2 = JNITypeParser.typeNameToSignature(string);
        List list = this.retrievedAllTypes ? this.findReferenceTypes(string2) : this.retrieveClassesBySignature(string2);
        return Collections.unmodifiableList(list);
    }

    public List allClasses() {
        this.validateVM();
        if (!this.retrievedAllTypes) {
            this.retrieveAllClasses();
        }
        return Collections.unmodifiableList(new ArrayList(this.typesBySignature));
    }

    public List allThreads() {
        this.validateVM();
        return this.state.allThreads();
    }

    public List topLevelThreadGroups() {
        this.validateVM();
        return this.state.topLevelThreadGroups();
    }

    PacketStream sendResumingCommand(CommandSender commandSender) {
        return this.state.thawCommand(commandSender);
    }

    void notifySuspend() {
        this.state.freeze();
    }

    public void suspend() {
        this.validateVM();
        try {
            JDWP.VirtualMachine.Suspend.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.notifySuspend();
    }

    public void resume() {
        this.validateVM();
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.VirtualMachine.Resume.enqueueCommand(VirtualMachineImpl.this.vm);
            }
        };
        PacketStream packetStream = this.state.thawCommand(commandSender);
        try {
            JDWP.VirtualMachine.Resume.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public EventQueue eventQueue() {
        return this.eventQueue;
    }

    public EventRequestManager eventRequestManager() {
        this.validateVM();
        return this.eventRequestManager;
    }

    public BooleanValue mirrorOf(boolean bl) {
        this.validateVM();
        return new BooleanValueImpl(this, bl);
    }

    public ByteValue mirrorOf(byte by) {
        this.validateVM();
        return new ByteValueImpl(this, by);
    }

    public CharValue mirrorOf(char c) {
        this.validateVM();
        return new CharValueImpl(this, c);
    }

    public ShortValue mirrorOf(short s) {
        this.validateVM();
        return new ShortValueImpl(this, s);
    }

    public IntegerValue mirrorOf(int n) {
        this.validateVM();
        return new IntegerValueImpl(this, n);
    }

    public LongValue mirrorOf(long l) {
        this.validateVM();
        return new LongValueImpl(this, l);
    }

    public FloatValue mirrorOf(float f) {
        this.validateVM();
        return new FloatValueImpl(this, f);
    }

    public DoubleValue mirrorOf(double d) {
        this.validateVM();
        return new DoubleValueImpl(this, d);
    }

    public StringReference mirrorOf(String string) {
        this.validateVM();
        try {
            return JDWP.VirtualMachine.CreateString.process((VirtualMachineImpl)this.vm, (String)string).stringObject;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public void dispose() {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Dispose.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.target.stopListening();
    }

    public void exit(int n) {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Exit.process(this.vm, n);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.target.stopListening();
    }

    public Process process() {
        this.validateVM();
        return this.process;
    }

    private JDWP.VirtualMachine.Version versionInfo() {
        try {
            if (this.versionInfo == null) {
                this.versionInfo = JDWP.VirtualMachine.Version.process(this.vm);
            }
            return this.versionInfo;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public String description() {
        Object[] objectArray = new String[]{"" + this.manager.majorInterfaceVersion(), "" + this.manager.minorInterfaceVersion(), this.versionInfo().description};
        this.validateVM();
        return MessageFormat.format(((VirtualMachineManagerImpl)this.manager).getString("version_format"), objectArray);
    }

    public String version() {
        this.validateVM();
        return this.versionInfo().vmVersion;
    }

    public String name() {
        this.validateVM();
        return this.versionInfo().vmName;
    }

    public boolean canWatchFieldModification() {
        this.validateVM();
        return this.capabilities().canWatchFieldModification;
    }

    public boolean canWatchFieldAccess() {
        this.validateVM();
        return this.capabilities().canWatchFieldAccess;
    }

    public boolean canGetBytecodes() {
        this.validateVM();
        return this.capabilities().canGetBytecodes;
    }

    public boolean canGetSyntheticAttribute() {
        this.validateVM();
        return this.capabilities().canGetSyntheticAttribute;
    }

    public boolean canGetOwnedMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetOwnedMonitorInfo;
    }

    public boolean canGetCurrentContendedMonitor() {
        this.validateVM();
        return this.capabilities().canGetCurrentContendedMonitor;
    }

    public boolean canGetMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetMonitorInfo;
    }

    public void setDebugTraceMode(int n) {
        this.validateVM();
        this.traceFlags = n;
        this.traceReceives = (n & 2) != 0;
    }

    void printTrace(String string) {
        System.err.println("[JDI: " + string + "]");
    }

    void printReceiveTrace(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("Receiving:");
        int n2 = n;
        while (n2 > 0) {
            stringBuffer.append("    ");
            --n2;
        }
        stringBuffer.append(string);
        this.printTrace(stringBuffer.toString());
    }

    private synchronized ReferenceTypeImpl addReferenceType(long l, int n, String string) {
        if (this.typesByID == null) {
            this.initReferenceTypes();
        }
        ReferenceTypeImpl referenceTypeImpl = null;
        switch (n) {
            case 1: {
                referenceTypeImpl = new ClassTypeImpl(this.vm, l);
                break;
            }
            case 2: {
                referenceTypeImpl = new InterfaceTypeImpl(this.vm, l);
                break;
            }
            case 3: {
                referenceTypeImpl = new ArrayTypeImpl(this.vm, l);
                break;
            }
            default: {
                throw new InternalException("Invalid reference type tag");
            }
        }
        if (string != null) {
            referenceTypeImpl.setSignature(string);
        }
        this.typesByID.put(new Long(l), referenceTypeImpl);
        this.typesBySignature.add(referenceTypeImpl);
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Caching new ReferenceType, sig=" + string + ", id=" + l);
        }
        return referenceTypeImpl;
    }

    synchronized void removeReferenceType(String string) {
        if (this.typesByID == null) {
            return;
        }
        Iterator iterator = this.typesBySignature.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)iterator.next();
            int n2 = string.compareTo(referenceTypeImpl.signature());
            if (n2 == 0) {
                ++n;
                iterator.remove();
                this.typesByID.remove(new Long(referenceTypeImpl.ref()));
                if ((this.vm.traceFlags & 8) == 0) continue;
                this.vm.printTrace("Uncaching ReferenceType, sig=" + string + ", id=" + referenceTypeImpl.ref());
                continue;
            }
            if (n2 < 0) break;
        }
        if (n > 1) {
            this.retrieveClassesBySignature(string);
        }
    }

    private synchronized List findReferenceTypes(String string) {
        if (this.typesByID == null) {
            return new ArrayList(0);
        }
        Iterator iterator = this.typesBySignature.iterator();
        ArrayList<ReferenceTypeImpl> arrayList = new ArrayList<ReferenceTypeImpl>();
        while (iterator.hasNext()) {
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)iterator.next();
            int n = string.compareTo(referenceTypeImpl.signature());
            if (n == 0) {
                arrayList.add(referenceTypeImpl);
                continue;
            }
            if (n < 0) break;
        }
        return arrayList;
    }

    private void initReferenceTypes() {
        this.typesByID = new HashMap(300);
        this.typesBySignature = new TreeSet(new SignatureComparator());
    }

    ReferenceTypeImpl referenceType(long l, byte by) {
        return this.referenceType(l, by, null);
    }

    ClassTypeImpl classType(long l) {
        return (ClassTypeImpl)this.referenceType(l, 1, null);
    }

    InterfaceTypeImpl interfaceType(long l) {
        return (InterfaceTypeImpl)this.referenceType(l, 2, null);
    }

    ArrayTypeImpl arrayType(long l) {
        return (ArrayTypeImpl)this.referenceType(l, 3, null);
    }

    ReferenceTypeImpl referenceType(long l, int n, String string) {
        Comparable<StringBuffer> comparable;
        if ((this.vm.traceFlags & 8) != 0) {
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append("Looking up ");
            if (n == 1) {
                ((StringBuffer)comparable).append("Class");
            } else if (n == 2) {
                ((StringBuffer)comparable).append("Interface");
            } else if (n == 3) {
                ((StringBuffer)comparable).append("ArrayType");
            } else {
                ((StringBuffer)comparable).append("UNKNOWN TAG: " + n);
            }
            if (string != null) {
                ((StringBuffer)comparable).append(", signature='" + string + "'");
            }
            ((StringBuffer)comparable).append(", id=" + l);
            this.vm.printTrace(((StringBuffer)comparable).toString());
        }
        if (l == 0L) {
            return null;
        }
        comparable = null;
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (this.typesByID != null) {
                comparable = (ReferenceTypeImpl)this.typesByID.get(new Long(l));
            }
            if (comparable == null) {
                comparable = this.addReferenceType(l, n, string);
            }
        }
        return comparable;
    }

    private JDWP.VirtualMachine.Capabilities capabilities() {
        if (this.capabilities == null) {
            try {
                this.capabilities = JDWP.VirtualMachine.Capabilities.process(this.vm);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.capabilities;
    }

    private List retrieveClassesBySignature(String string) {
        JDWP.VirtualMachine.ClassesBySignature.ClassInfo[] classInfoArray;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving matching ReferenceTypes, sig=" + string);
        }
        try {
            classInfoArray = JDWP.VirtualMachine.ClassesBySignature.process((VirtualMachineImpl)this.vm, (String)string).classes;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        int n = classInfoArray.length;
        ArrayList<ReferenceTypeImpl> arrayList = new ArrayList<ReferenceTypeImpl>(n);
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            int n2 = 0;
            while (n2 < n) {
                JDWP.VirtualMachine.ClassesBySignature.ClassInfo classInfo = classInfoArray[n2];
                ReferenceTypeImpl referenceTypeImpl = this.referenceType(classInfo.typeID, classInfo.refTypeTag, string);
                referenceTypeImpl.setStatus(classInfo.status);
                arrayList.add(referenceTypeImpl);
                ++n2;
            }
        }
        return arrayList;
    }

    private void retrieveAllClasses() {
        JDWP.VirtualMachine.AllClasses.ClassInfo[] classInfoArray;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving all ReferenceTypes");
        }
        try {
            classInfoArray = JDWP.VirtualMachine.AllClasses.process((VirtualMachineImpl)this.vm).classes;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                int n = classInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JDWP.VirtualMachine.AllClasses.ClassInfo classInfo = classInfoArray[n2];
                    ReferenceTypeImpl referenceTypeImpl = this.referenceType(classInfo.typeID, classInfo.refTypeTag, classInfo.signature);
                    referenceTypeImpl.setStatus(classInfo.status);
                    ++n2;
                }
                this.retrievedAllTypes = true;
            }
        }
    }

    void sendToTarget(Packet packet) {
        this.target.send(packet);
    }

    void waitForTargetReply(Packet packet) {
        this.target.waitForReply(packet);
        this.processBatchedDisposes();
    }

    Type findBootType(String string) throws ClassNotLoadedException {
        Object object;
        List list = this.allClasses();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ReferenceType)iterator.next();
            if (object.classLoader() != null || !object.signature().equals(string)) continue;
            return object;
        }
        object = new JNITypeParser(string);
        throw new ClassNotLoadedException(((JNITypeParser)object).typeName(), "Type " + ((JNITypeParser)object).typeName() + " not loaded");
    }

    BooleanType theBooleanType() {
        if (this.theBooleanType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theBooleanType == null) {
                    this.theBooleanType = new BooleanTypeImpl(this);
                }
            }
        }
        return this.theBooleanType;
    }

    ByteType theByteType() {
        if (this.theByteType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theByteType == null) {
                    this.theByteType = new ByteTypeImpl(this);
                }
            }
        }
        return this.theByteType;
    }

    CharType theCharType() {
        if (this.theCharType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theCharType == null) {
                    this.theCharType = new CharTypeImpl(this);
                }
            }
        }
        return this.theCharType;
    }

    ShortType theShortType() {
        if (this.theShortType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theShortType == null) {
                    this.theShortType = new ShortTypeImpl(this);
                }
            }
        }
        return this.theShortType;
    }

    IntegerType theIntegerType() {
        if (this.theIntegerType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theIntegerType == null) {
                    this.theIntegerType = new IntegerTypeImpl(this);
                }
            }
        }
        return this.theIntegerType;
    }

    LongType theLongType() {
        if (this.theLongType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theLongType == null) {
                    this.theLongType = new LongTypeImpl(this);
                }
            }
        }
        return this.theLongType;
    }

    FloatType theFloatType() {
        if (this.theFloatType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theFloatType == null) {
                    this.theFloatType = new FloatTypeImpl(this);
                }
            }
        }
        return this.theFloatType;
    }

    DoubleType theDoubleType() {
        if (this.theDoubleType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theDoubleType == null) {
                    this.theDoubleType = new DoubleTypeImpl(this);
                }
            }
        }
        return this.theDoubleType;
    }

    VoidType theVoidType() {
        if (this.theVoidType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theVoidType == null) {
                    this.theVoidType = new VoidTypeImpl(this);
                }
            }
        }
        return this.theVoidType;
    }

    PrimitiveType primitiveTypeMirror(byte by) {
        switch (by) {
            case 90: {
                return this.theBooleanType();
            }
            case 66: {
                return this.theByteType();
            }
            case 67: {
                return this.theCharType();
            }
            case 83: {
                return this.theShortType();
            }
            case 73: {
                return this.theIntegerType();
            }
            case 74: {
                return this.theLongType();
            }
            case 70: {
                return this.theFloatType();
            }
            case 68: {
                return this.theDoubleType();
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive tag " + by);
    }

    private void processBatchedDisposes() {
        if (this.shutdown) {
            return;
        }
        JDWP.VirtualMachine.DisposeObjects.Request[] requestArray = null;
        List list = this.batchedDisposeRequests;
        synchronized (list) {
            int n = this.batchedDisposeRequests.size();
            if (n >= 50) {
                if ((this.traceFlags & 0x10) != 0) {
                    this.printTrace("Dispose threashold reached. Will dispose " + n + " object references...");
                }
                requestArray = new JDWP.VirtualMachine.DisposeObjects.Request[n];
                int n2 = 0;
                while (n2 < requestArray.length) {
                    SoftObjectReference softObjectReference = (SoftObjectReference)this.batchedDisposeRequests.get(n2);
                    if ((this.traceFlags & 0x10) != 0) {
                        this.printTrace("Disposing object " + softObjectReference.key() + " (ref count = " + softObjectReference.count() + ")");
                    }
                    requestArray[n2] = new JDWP.VirtualMachine.DisposeObjects.Request(new ObjectReferenceImpl(this, softObjectReference.key()), softObjectReference.count());
                    ++n2;
                }
                this.batchedDisposeRequests.clear();
            }
        }
        if (requestArray != null) {
            try {
                JDWP.VirtualMachine.DisposeObjects.process(this.vm, requestArray);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
    }

    private void batchForDispose(SoftObjectReference softObjectReference) {
        if ((this.traceFlags & 0x10) != 0) {
            this.printTrace("Batching object " + softObjectReference.key() + " for dispose (ref count = " + softObjectReference.count() + ")");
        }
        this.batchedDisposeRequests.add(softObjectReference);
    }

    private void processQueue() {
        Reference reference;
        while ((reference = this.referenceQueue.poll()) != null) {
            SoftObjectReference softObjectReference = (SoftObjectReference)reference;
            this.removeObjectMirror(softObjectReference);
            this.batchForDispose(softObjectReference);
        }
    }

    synchronized ObjectReferenceImpl objectMirror(long l, int n) {
        this.processQueue();
        if (l == 0L) {
            return null;
        }
        ObjectReferenceImpl objectReferenceImpl = null;
        Long l2 = new Long(l);
        SoftObjectReference softObjectReference = (SoftObjectReference)this.objectsByID.get(l2);
        if (softObjectReference != null) {
            objectReferenceImpl = softObjectReference.object();
        }
        if (objectReferenceImpl == null) {
            switch (n) {
                case 76: {
                    objectReferenceImpl = new ObjectReferenceImpl(this.vm, l);
                    break;
                }
                case 115: {
                    objectReferenceImpl = new StringReferenceImpl(this.vm, l);
                    break;
                }
                case 91: {
                    objectReferenceImpl = new ArrayReferenceImpl(this.vm, l);
                    break;
                }
                case 116: {
                    ThreadReferenceImpl threadReferenceImpl = new ThreadReferenceImpl(this.vm, l);
                    threadReferenceImpl.addListener(this);
                    objectReferenceImpl = threadReferenceImpl;
                    break;
                }
                case 103: {
                    objectReferenceImpl = new ThreadGroupReferenceImpl(this.vm, l);
                    break;
                }
                case 108: {
                    objectReferenceImpl = new ClassLoaderReferenceImpl(this.vm, l);
                    break;
                }
                case 99: {
                    objectReferenceImpl = new ClassObjectReferenceImpl(this.vm, l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid object tag: " + n);
                }
            }
            softObjectReference = new SoftObjectReference(l2, objectReferenceImpl, this.referenceQueue);
            this.objectsByID.put(l2, softObjectReference);
            if ((this.traceFlags & 0x10) != 0) {
                this.printTrace("Creating new " + objectReferenceImpl.getClass().getName() + " (id = " + l + ")");
            }
        } else {
            softObjectReference.incrementCount();
        }
        return objectReferenceImpl;
    }

    synchronized void removeObjectMirror(ObjectReferenceImpl objectReferenceImpl) {
        this.processQueue();
        SoftObjectReference softObjectReference = (SoftObjectReference)this.objectsByID.remove(new Long(objectReferenceImpl.ref()));
        if (softObjectReference == null) {
            throw new InternalException("ObjectReference " + objectReferenceImpl.ref() + " not found in object cache");
        }
        this.batchForDispose(softObjectReference);
    }

    synchronized void removeObjectMirror(SoftObjectReference softObjectReference) {
        this.objectsByID.remove(softObjectReference.key());
    }

    ObjectReferenceImpl objectMirror(long l) {
        return this.objectMirror(l, 76);
    }

    StringReferenceImpl stringMirror(long l) {
        return (StringReferenceImpl)this.objectMirror(l, 115);
    }

    ArrayReferenceImpl arrayMirror(long l) {
        return (ArrayReferenceImpl)this.objectMirror(l, 91);
    }

    ThreadReferenceImpl threadMirror(long l) {
        return (ThreadReferenceImpl)this.objectMirror(l, 116);
    }

    ThreadGroupReferenceImpl threadGroupMirror(long l) {
        return (ThreadGroupReferenceImpl)this.objectMirror(l, 103);
    }

    ClassLoaderReferenceImpl classLoaderMirror(long l) {
        return (ClassLoaderReferenceImpl)this.objectMirror(l, 108);
    }

    ClassObjectReferenceImpl classObjectMirror(long l) {
        return (ClassObjectReferenceImpl)this.objectMirror(l, 99);
    }

    private JDWP.VirtualMachine.ClassPaths getClasspath() {
        if (this.pathInfo == null) {
            try {
                this.pathInfo = JDWP.VirtualMachine.ClassPaths.process(this.vm);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.pathInfo;
    }

    public List classPath() {
        return Arrays.asList(this.getClasspath().classpaths);
    }

    public List bootClassPath() {
        return Arrays.asList(this.getClasspath().bootclasspaths);
    }

    public String baseDirectory() {
        return this.getClasspath().baseDir;
    }

    private static class SignatureComparator
    implements Comparator {
        private SignatureComparator() {
        }

        String objectToSignature(Object object) {
            return ((ReferenceType)object).signature();
        }

        public int compare(Object object, Object object2) {
            String string = this.objectToSignature(object);
            String string2 = this.objectToSignature(object2);
            return string.compareTo(string2);
        }
    }

    private static class SoftObjectReference
    extends SoftReference {
        int count = 1;
        Long key;

        SoftObjectReference(Long l, ObjectReferenceImpl objectReferenceImpl, ReferenceQueue referenceQueue) {
            super(objectReferenceImpl, referenceQueue);
            this.key = l;
        }

        int count() {
            return this.count;
        }

        void incrementCount() {
            ++this.count;
        }

        Long key() {
            return this.key;
        }

        ObjectReferenceImpl object() {
            return (ObjectReferenceImpl)this.get();
        }
    }
}

