/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;

public class PrintGenerator
implements Generator,
Constants {
    private static final int JAVA = 0;
    private static final int IDL = 1;
    private static final int BOTH = 2;
    private int whatToPrint;
    private boolean global = false;
    private boolean qualified = false;
    private boolean trace = false;
    private boolean valueMethods = false;
    private IndentingWriter out;

    public PrintGenerator() {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        this.out = new IndentingWriter(outputStreamWriter);
    }

    public boolean parseArgs(String[] stringArray, Main main) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                String string = stringArray[n].toLowerCase();
                if (string.equals("-xprint")) {
                    this.whatToPrint = 0;
                    stringArray[n] = null;
                    if (n + 1 < stringArray.length) {
                        if (stringArray[n + 1].equalsIgnoreCase("idl")) {
                            stringArray[++n] = null;
                            this.whatToPrint = 1;
                        } else if (stringArray[n + 1].equalsIgnoreCase("both")) {
                            stringArray[++n] = null;
                            this.whatToPrint = 2;
                        }
                    }
                } else if (string.equals("-xglobal")) {
                    this.global = true;
                    stringArray[n] = null;
                } else if (string.equals("-xqualified")) {
                    this.qualified = true;
                    stringArray[n] = null;
                } else if (string.equals("-xtrace")) {
                    this.trace = true;
                    stringArray[n] = null;
                } else if (string.equals("-xvaluemethods")) {
                    this.valueMethods = true;
                    stringArray[n] = null;
                }
            }
            ++n;
        }
        return true;
    }

    public void generate(sun.rmi.rmic.BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        CompoundType compoundType;
        BatchEnvironment batchEnvironment2 = (BatchEnvironment)batchEnvironment;
        ContextStack contextStack = new ContextStack(batchEnvironment2);
        contextStack.setTrace(this.trace);
        if (this.valueMethods) {
            batchEnvironment2.setParseNonConforming(true);
        }
        if ((compoundType = CompoundType.forCompound(classDefinition, contextStack)) != null) {
            try {
                Type[] typeArray = compoundType.collectMatching(0x2000000);
                int n = 0;
                while (n < typeArray.length) {
                    this.out.pln("\n-----------------------------------------------------------\n");
                    Type type = typeArray[n];
                    switch (this.whatToPrint) {
                        case 0: {
                            type.println(this.out, this.qualified, false, false);
                            break;
                        }
                        case 1: {
                            type.println(this.out, this.qualified, true, this.global);
                            break;
                        }
                        case 2: {
                            type.println(this.out, this.qualified, false, false);
                            type.println(this.out, this.qualified, true, this.global);
                            break;
                        }
                        default: {
                            throw new CompilerError("Unknown type!");
                        }
                    }
                    ++n;
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new CompilerError("PrintGenerator caught " + iOException);
            }
        }
    }
}

