/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.ttydebug;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.tools.debug.DebuggerCallback;
import sun.tools.debug.NoSuchLineNumberException;
import sun.tools.debug.RemoteArray;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteDebugger;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteInt;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteStackVariable;
import sun.tools.debug.RemoteThread;
import sun.tools.debug.RemoteThreadGroup;
import sun.tools.debug.RemoteValue;

public class TTY
implements DebuggerCallback {
    RemoteDebugger debugger;
    RemoteThread currentThread;
    RemoteThreadGroup currentThreadGroup;
    PrintStream out = null;
    PrintStream console = null;
    private static final String progname = "oldjdb";
    private static final String version = "00/02/02";
    private String lastArgs = null;
    static final String printDelimiters = ".[(";

    private RemoteThread indexToThread(int n) throws Exception {
        this.setDefaultThreadGroup();
        RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
        if (n == 0 || n > remoteThreadArray.length) {
            return null;
        }
        return remoteThreadArray[n - 1];
    }

    private int parseThreadId(String string) throws Exception {
        int n;
        if (string.startsWith("t@")) {
            string = string.substring(2);
        }
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (this.indexToThread(n) == null) {
            this.out.println("\"" + string + "\" is not a valid thread id.");
            return 0;
        }
        return n;
    }

    private void printPrompt() throws Exception {
        if (this.currentThread == null) {
            this.out.print("> ");
        } else {
            this.out.print(this.currentThread.getName() + "[" + (this.currentThread.getCurrentFrameIndex() + 1) + "] ");
        }
        this.out.flush();
    }

    public synchronized void printToConsole(String string) throws Exception {
        this.console.print(string);
        this.console.flush();
    }

    public void breakpointEvent(RemoteThread remoteThread) throws Exception {
        this.out.print("\nBreakpoint hit: ");
        RemoteStackFrame[] remoteStackFrameArray = remoteThread.dumpStack();
        if (remoteStackFrameArray.length > 0) {
            this.out.println(remoteStackFrameArray[0].toString());
            this.currentThread = remoteThread;
        } else {
            this.currentThread = null;
            this.out.println("Invalid thread specified in breakpoint.");
        }
        this.printPrompt();
    }

    public void exceptionEvent(RemoteThread remoteThread, String string) throws Exception {
        this.out.println("\n" + string);
        remoteThread.setCurrentFrameIndex(0);
        this.currentThread = remoteThread;
        this.printPrompt();
    }

    public void threadDeathEvent(RemoteThread remoteThread) throws Exception {
        if (remoteThread == this.currentThread) {
            String string;
            try {
                string = " \"" + remoteThread.getName() + "\"";
            }
            catch (Exception exception) {
                string = "";
            }
            this.currentThread = null;
            this.out.println();
            this.out.println("Current thread" + string + " died. Execution continuing...");
            this.printPrompt();
        }
    }

    public void quitEvent() throws Exception {
        StringTokenizer stringTokenizer;
        String string = null;
        if (this.lastArgs != null && (stringTokenizer = new StringTokenizer(this.lastArgs)).hasMoreTokens()) {
            string = new String("\n" + stringTokenizer.nextToken() + " exited");
        }
        if (string == null) {
            string = new String("\nThe application exited");
        }
        this.out.println(string);
        this.currentThread = null;
        System.exit(0);
    }

    void classes() throws Exception {
        RemoteClass[] remoteClassArray = this.debugger.listClasses();
        this.out.println("** classes list **");
        int n = 0;
        while (n < remoteClassArray.length) {
            this.out.println(remoteClassArray[n].description());
            ++n;
        }
    }

    void methods(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            RemoteClass remoteClass = this.getClassFromToken(string);
            RemoteField[] remoteFieldArray = remoteClass.getMethods();
            int n = 0;
            while (n < remoteFieldArray.length) {
                this.out.println(remoteFieldArray[n].getTypedName());
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
        }
    }

    int printThreadGroup(RemoteThreadGroup remoteThreadGroup, int n) throws Exception {
        int n2;
        Object[] objectArray;
        int n3;
        this.out.println("Group " + remoteThreadGroup.getName() + ":");
        RemoteThread[] remoteThreadArray = remoteThreadGroup.listThreads(false);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < remoteThreadArray.length) {
            String string;
            int n7 = remoteThreadArray[n6].description().length();
            if (n7 > n4) {
                n4 = n7;
            }
            if ((n3 = (string = remoteThreadArray[n6].getName()).lastIndexOf(46)) >= 0 && string.length() > n3) {
                string = string.substring(n3 + 1);
            }
            if (string.length() > n5) {
                n5 = string.length();
            }
            ++n6;
        }
        String string = String.valueOf(n + remoteThreadArray.length);
        int n8 = string.length();
        n3 = 0;
        while (n3 < remoteThreadArray.length) {
            objectArray = new char[80];
            n2 = 0;
            while (n2 < 79) {
                objectArray[n2] = 32;
                ++n2;
            }
            objectArray[79] = '\u0000';
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char[])objectArray);
            String string2 = String.valueOf(n + n3 + 1);
            stringBuffer.insert(n8 - string2.length(), string2);
            stringBuffer.insert(n8, ".");
            int n9 = n8 + 2;
            stringBuffer.insert(n9, remoteThreadArray[n3].description());
            n9 += n4 + 1;
            String string3 = remoteThreadArray[n3].getName();
            int n10 = string3.lastIndexOf(46);
            if (n10 >= 0 && string3.length() > n10) {
                string3 = string3.substring(n10 + 1);
            }
            stringBuffer.insert(n9, string3);
            stringBuffer.insert(n9 += n5 + 1, remoteThreadArray[n3].getStatus());
            stringBuffer.setLength(79);
            this.out.println(stringBuffer.toString());
            ++n3;
        }
        objectArray = this.debugger.listThreadGroups(remoteThreadGroup);
        n2 = 0;
        while (n2 < objectArray.length) {
            if (remoteThreadGroup != objectArray[n2]) {
                n += this.printThreadGroup((RemoteThreadGroup)objectArray[n2], n + remoteThreadArray.length);
            }
            ++n2;
        }
        return remoteThreadArray.length;
    }

    private void setDefaultThreadGroup() throws Exception {
        if (this.currentThreadGroup == null) {
            RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
            this.currentThreadGroup = remoteThreadGroupArray[0];
        }
    }

    void threads(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.setDefaultThreadGroup();
            this.printThreadGroup(this.currentThreadGroup, 0);
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            if (string.equals(remoteThreadGroupArray[n].getName())) {
                this.printThreadGroup(remoteThreadGroupArray[n], 0);
                return;
            }
            ++n;
        }
        this.out.println(string + " is not a valid threadgroup name.");
    }

    void threadGroups() throws Exception {
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            this.out.println(new Integer(n + 1).toString() + ". " + remoteThreadGroupArray[n].description() + " " + remoteThreadGroupArray[n].getName());
            ++n;
        }
    }

    void setThread(int n) throws Exception {
        this.setDefaultThreadGroup();
        RemoteThread remoteThread = this.indexToThread(n);
        if (remoteThread == null) {
            this.out.println("\"" + n + "\" is not a valid thread id.");
            return;
        }
        this.currentThread = remoteThread;
    }

    void thread(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Thread number not specified.");
            return;
        }
        int n = this.parseThreadId(stringTokenizer.nextToken());
        if (n == 0) {
            return;
        }
        this.setThread(n);
    }

    void threadGroup(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Threadgroup name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            if (string.equals(remoteThreadGroupArray[n].getName())) {
                this.currentThreadGroup = remoteThreadGroupArray[n];
                return;
            }
            ++n;
        }
        this.out.println(string + " is not a valid threadgroup name.");
    }

    void run(StringTokenizer stringTokenizer) throws Exception {
        RemoteObject remoteObject;
        String[] stringArray = new String[100];
        int n = 0;
        if (!stringTokenizer.hasMoreTokens() && this.lastArgs != null) {
            stringTokenizer = new StringTokenizer(this.lastArgs);
            this.out.println("run " + this.lastArgs);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
            if (n != 1) continue;
            remoteObject = this.debugger.findClass(stringArray[0]);
            if (remoteObject == null) {
                this.out.println("Could not load the " + stringArray[0] + " class.");
                return;
            }
            stringArray[0] = ((RemoteClass)remoteObject).getName();
        }
        if (n > 0) {
            remoteObject = this.debugger.run(n, stringArray);
            if (remoteObject != null) {
                this.currentThreadGroup = remoteObject;
                this.setThread(1);
                this.out.println("running ...");
            } else {
                this.out.println(stringArray[0] + " failed.");
            }
        } else {
            this.out.println("No class name specified.");
        }
    }

    void load(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Class name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteClass remoteClass = this.debugger.findClass(string);
        if (remoteClass == null) {
            this.out.print(string + " not found");
            this.out.println(string.indexOf(46) > 0 ? " (try the full name)" : "");
        } else {
            this.out.println(remoteClass.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    void suspend(StringTokenizer var1_1) throws Exception {
        block5: {
            if (var1_1.hasMoreTokens()) ** GOTO lbl22
            this.setDefaultThreadGroup();
            var2_2 = this.currentThreadGroup.listThreads(true);
            var3_4 = 0;
            while (var3_4 < var2_2.length) {
                var2_2[var3_4].suspend();
                ++var3_4;
            }
            this.out.println("All (non-system) threads suspended.");
            break block5;
lbl-1000:
            // 1 sources

            {
                var2_3 = var1_1.nextToken();
                try {
                    var3_5 = Integer.valueOf(var2_3);
                }
                catch (NumberFormatException var4_7) {
                    var3_5 = 0;
                }
                var4_6 = this.indexToThread(var3_5);
                if (var4_6 == null) {
                    this.out.println("\"" + var2_3 + "\" is not a valid thread id.");
                    continue;
                }
                var4_6.suspend();
lbl22:
                // 3 sources

                ** while (var1_1.hasMoreTokens())
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void resume(StringTokenizer var1_1) throws Exception {
        block6: {
            if (var1_1.hasMoreTokens()) ** GOTO lbl26
            this.setDefaultThreadGroup();
            var2_2 = this.currentThreadGroup.listThreads(true);
            var3_4 = 0;
            while (var3_4 < var2_2.length) {
                var2_2[var3_4].resume();
                ++var3_4;
            }
            if (this.currentThread != null) {
                this.currentThread.resetCurrentFrameIndex();
            }
            this.out.println("All threads resumed.");
            break block6;
lbl-1000:
            // 1 sources

            {
                var2_3 = var1_1.nextToken();
                try {
                    var3_5 = Integer.valueOf(var2_3);
                }
                catch (NumberFormatException var4_7) {
                    var3_5 = 0;
                }
                var4_6 = this.indexToThread(var3_5);
                if (var4_6 == null) {
                    this.out.println("\"" + var2_3 + "\" is not a valid thread id.");
                    continue;
                }
                var4_6.resume();
                if (var4_6 != this.currentThread) continue;
                this.currentThread.resetCurrentFrameIndex();
lbl26:
                // 4 sources

                ** while (var1_1.hasMoreTokens())
            }
        }
    }

    void cont() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        this.debugger.cont();
    }

    void step(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().toLowerCase();
                if (string.equals("up")) {
                    this.currentThread.stepOut();
                } else {
                    this.currentThread.step(true);
                }
            } else {
                this.currentThread.step(true);
            }
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not suspended.");
        }
    }

    void stepi() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            this.currentThread.step(false);
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not suspended.");
        }
    }

    void next() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            this.currentThread.next();
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not suspended.");
        }
    }

    /*
     * Unable to fully structure code
     */
    void kill(StringTokenizer var1_1) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl26
        this.out.println("Usage: kill <threadgroup name> or <thread id>");
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.nextToken();
            try {
                var3_3 = Integer.valueOf(var2_2);
            }
            catch (NumberFormatException var4_5) {
                var3_3 = 0;
            }
            var4_4 = this.indexToThread(var3_3);
            if (var4_4 != null) {
                this.out.println("killing thread: " + var4_4.getName());
                var4_4.stop();
                return;
            }
            var5_6 = this.debugger.listThreadGroups(null);
            var5_6 = this.debugger.listThreadGroups(var5_6[0]);
            var6_7 = 0;
            while (var6_7 < var5_6.length) {
                if (var5_6[var6_7].getName().equals(var2_2)) {
                    this.out.println("killing threadgroup: " + var2_2);
                    var5_6[var6_7].stop();
                    return;
                }
                ++var6_7;
            }
            this.out.println("\"" + var2_2 + "\" is not a valid threadgroup or id.");
lbl26:
            // 2 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl27:
        // 1 sources

    }

    void catchException(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            String[] stringArray = this.debugger.getExceptionCatchList();
            int n = 0;
            while (n < stringArray.length) {
                this.out.print("  " + stringArray[n]);
                if ((n & 4) == 3 || n == stringArray.length - 1) {
                    this.out.println();
                }
                ++n;
            }
        } else {
            String string = stringTokenizer.nextToken();
            try {
                RemoteClass remoteClass = this.getClassFromToken(string);
                remoteClass.catchExceptions();
            }
            catch (Exception exception) {
                this.out.println("Invalid exception class name: " + string);
            }
        }
    }

    void ignoreException(StringTokenizer stringTokenizer) throws Exception {
        String[] stringArray = this.debugger.getExceptionCatchList();
        if (!stringTokenizer.hasMoreTokens()) {
            int n = 0;
            while (n < stringArray.length) {
                this.out.print("  " + stringArray[n]);
                if ((n & 4) == 3 || n == stringArray.length - 1) {
                    this.out.println();
                }
                ++n;
            }
        } else {
            String string = stringTokenizer.nextToken();
            try {
                RemoteClass remoteClass = this.getClassFromToken(string);
                boolean bl = false;
                int n = 0;
                while (n < stringArray.length) {
                    if (string.equals(stringArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    this.out.println("Exception not currently caught: " + string);
                }
                remoteClass.ignoreExceptions();
            }
            catch (Exception exception) {
                this.out.println("Invalid exception class name: " + string);
            }
        }
    }

    void up(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 == 0) {
                this.out.println("Usage: up [n frames]");
                return;
            }
            n = n2;
        }
        try {
            this.currentThread.up(n);
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Thread isn't suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
        }
    }

    void down(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 == 0) {
                this.out.println("usage: down [n frames]");
                return;
            }
            n = n2;
        }
        try {
            this.currentThread.down(n);
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Thread isn't suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
        }
    }

    void dumpStack(RemoteThread remoteThread, boolean bl) throws Exception {
        RemoteStackFrame[] remoteStackFrameArray = remoteThread.dumpStack();
        if (remoteStackFrameArray.length == 0) {
            this.out.println("Thread is not running (no stack).");
        } else {
            int n = remoteStackFrameArray.length;
            int n2 = remoteThread.getCurrentFrameIndex();
            while (n2 < n) {
                this.out.print("  [" + (n2 + 1) + "] ");
                this.out.print(remoteStackFrameArray[n2].toString());
                if (bl) {
                    this.out.print(", pc = " + remoteStackFrameArray[n2].getPC());
                }
                this.out.println();
                ++n2;
            }
        }
    }

    void where(StringTokenizer stringTokenizer, boolean bl) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            if (this.currentThread == null) {
                this.out.println("No thread specified.");
                return;
            }
            this.dumpStack(this.currentThread, bl);
        } else {
            String string = stringTokenizer.nextToken();
            if (string.toLowerCase().equals("all")) {
                this.setDefaultThreadGroup();
                RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
                int n = 0;
                while (n < remoteThreadArray.length) {
                    this.out.println(remoteThreadArray[n].getName() + ": ");
                    this.dumpStack(remoteThreadArray[n], bl);
                    ++n;
                }
            } else {
                int n = this.parseThreadId(string);
                if (n == 0) {
                    return;
                }
                this.dumpStack(this.indexToThread(n), bl);
            }
        }
    }

    void trace(String string, StringTokenizer stringTokenizer) throws Exception {
        boolean bl;
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("(i)trace < \"on\" | \"off\" >");
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("on")) {
            bl = true;
        } else if (string2.equals("off")) {
            bl = false;
        } else {
            this.out.println("(i)trace < \"on\" | \"off\" >");
            return;
        }
        if (string.equals("trace")) {
            this.debugger.trace(bl);
        } else {
            this.debugger.itrace(bl);
        }
    }

    void memory() throws Exception {
        this.out.println("Free: " + this.debugger.freeMemory() + ", total: " + this.debugger.totalMemory());
    }

    void gc() throws Exception {
        RemoteObject[] remoteObjectArray = new RemoteObject[]{this.currentThread, this.currentThreadGroup};
        this.debugger.gc(remoteObjectArray);
    }

    private RemoteClass getClassFromToken(String string) throws Exception {
        RemoteObject remoteObject;
        if (string.startsWith("0x") || Character.isDigit(string.charAt(0))) {
            int n;
            try {
                n = RemoteValue.fromHex(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n == 0 || (remoteObject = this.debugger.get(new Integer(n))) == null) {
                throw new IllegalArgumentException();
            }
            if (!(remoteObject instanceof RemoteClass)) {
                throw new IllegalArgumentException();
            }
        } else {
            remoteObject = this.debugger.findClass(string);
            if (remoteObject == null) {
                throw new IllegalArgumentException();
            }
        }
        return remoteObject;
    }

    void listBreakpoints() throws Exception {
        String[] stringArray = this.debugger.listBreakpoints();
        if (stringArray.length > 0) {
            this.out.println("Current breakpoints set:");
            int n = 0;
            while (n < stringArray.length) {
                this.out.println("\t" + stringArray[n]);
                ++n;
            }
        } else {
            this.out.println("No breakpoints set.");
        }
    }

    private boolean compareArgTypes(RemoteField remoteField, Vector vector) {
        String string = remoteField.getTypedName();
        int n = string.indexOf("(");
        if (n == -1) {
            throw new IllegalArgumentException("Method expected");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n), "(,) \t\n\r");
        if (stringTokenizer.countTokens() != vector.size()) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (string3.equals(string2 = stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    private String normalizeArgTypeName(String string) throws Exception {
        char c;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        string = string.trim();
        while (n < string.length()) {
            c = string.charAt(n);
            if (Character.isWhitespace(c) || c == '[') break;
            stringBuffer.append(c);
            ++n;
        }
        while (n < string.length()) {
            c = string.charAt(n);
            if (c == '[' || c == ']') {
                stringBuffer2.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new IllegalArgumentException("Invalid argument type name");
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string.indexOf(46) == -1) {
            try {
                RemoteClass remoteClass = this.getClassFromToken(string);
                string = remoteClass.getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        string = string + stringBuffer2.toString();
        return string;
    }

    RemoteField findMatchingMethod(RemoteClass remoteClass, String string, String string2) throws Exception {
        RemoteField remoteField;
        if (!(string2.length() <= 0 || string2.startsWith("(") && string2.endsWith(")"))) {
            this.out.println("Invalid method specification: '" + string + string2 + "'");
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "(,)");
        Vector<String> vector = new Vector<String>();
        String string3 = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string3 = this.normalizeArgTypeName(string3);
                vector.addElement(string3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("Invalid Argument Type: '" + string3 + "'");
            return null;
        }
        RemoteField[] remoteFieldArray = remoteClass.getMethods();
        RemoteField remoteField2 = null;
        RemoteField remoteField3 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < remoteFieldArray.length) {
            remoteField = remoteFieldArray[n2];
            if (remoteField.getName().equals(string)) {
                if (++n == 1) {
                    remoteField2 = remoteField;
                }
                if (!string2.equals("") && this.compareArgTypes(remoteField, vector)) {
                    remoteField3 = remoteField;
                    break;
                }
            }
            ++n2;
        }
        remoteField = null;
        if (remoteField3 != null) {
            remoteField = remoteField3;
        } else if (string2.equals("") && n > 0) {
            if (n == 1) {
                remoteField = remoteField2;
            } else {
                this.out.println(remoteClass.getName() + "." + string + " is overloaded, use one of the following:");
                int n3 = 0;
                while (n3 < remoteFieldArray.length) {
                    if (string.equals(remoteFieldArray[n3].getName())) {
                        this.out.println("  " + remoteFieldArray[n3].getTypedName());
                    }
                    ++n3;
                }
            }
        } else {
            this.out.println("Class " + remoteClass.getName() + " doesn't have a method " + string + string2);
        }
        return remoteField;
    }

    void stop(StringTokenizer stringTokenizer) throws Exception {
        block21: {
            if (!stringTokenizer.hasMoreTokens()) {
                this.listBreakpoints();
                return;
            }
            String string = null;
            try {
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("at")) {
                    boolean bl = true;
                } else if (string3.equals("in")) {
                    boolean bl = false;
                } else {
                    this.out.println("Usage: stop at <class>:<line_number> or");
                    this.out.println("       stop in <class>.<method_name>[(argument_type,...)]");
                    return;
                }
                if (string3.equals("at")) {
                    String string4;
                    int n;
                    string = stringTokenizer.nextToken(": \t\n\r");
                    RemoteClass remoteClass = this.getClassFromToken(string);
                    String string5 = remoteClass.setBreakpointLine(n = Integer.valueOf(string4 = stringTokenizer.nextToken()).intValue());
                    if (string5.length() > 0) {
                        this.out.println(string5);
                    } else {
                        this.out.println("Breakpoint set at " + remoteClass.getName() + ":" + n);
                    }
                    break block21;
                }
                string = stringTokenizer.nextToken(":( \t\n\r");
                RemoteClass remoteClass = null;
                String string6 = null;
                try {
                    remoteClass = this.getClassFromToken(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    int n = string.lastIndexOf(".");
                    if (n == -1) {
                        this.out.println("\"" + string + "\" is not a valid id or class name.");
                        return;
                    }
                    string6 = string.substring(n + 1);
                    string = string.substring(0, n);
                    remoteClass = this.getClassFromToken(string);
                }
                if (string6 == null) {
                    string6 = stringTokenizer.nextToken();
                }
                try {
                    string2 = stringTokenizer.nextToken("").trim();
                }
                catch (NoSuchElementException noSuchElementException) {
                    string2 = "";
                }
                RemoteField remoteField = this.findMatchingMethod(remoteClass, string6, string2);
                if (remoteField != null) {
                    String string7 = remoteClass.setBreakpointMethod(remoteField);
                    if (string7.length() > 0) {
                        this.out.println(string7);
                    } else {
                        this.out.println("Breakpoint set in " + remoteClass.getName() + "." + string6 + string2);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.out.println("Usage: stop at <class>:<line_number> or");
                this.out.println("       stop in <class>.<method_name>[(argument_type,...)]");
            }
            catch (NumberFormatException numberFormatException) {
                this.out.println("Invalid line number.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.out.println("\"" + string + "\" is not a valid id or class name.");
            }
        }
    }

    void clear(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        String string = null;
        String string2 = null;
        RemoteClass remoteClass = null;
        try {
            string = stringTokenizer.nextToken(":( \t\n\r");
            try {
                remoteClass = this.getClassFromToken(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string3;
                int n = string.lastIndexOf(".");
                if (n == -1) {
                    this.out.println("\"" + string + "\" is not a valid id or class name.");
                    return;
                }
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
                remoteClass = this.getClassFromToken(string);
                try {
                    string3 = stringTokenizer.nextToken("").trim();
                }
                catch (NoSuchElementException noSuchElementException) {
                    string3 = "";
                }
                RemoteField remoteField = this.findMatchingMethod(remoteClass, string2, string3);
                if (remoteField != null) {
                    String string4 = remoteClass.clearBreakpointMethod(remoteField);
                    if (string4.length() > 0) {
                        this.out.println(string4);
                    } else {
                        this.out.println("Breakpoint cleared at " + remoteClass.getName() + "." + string2 + string3);
                    }
                }
                return;
            }
            String string5 = stringTokenizer.nextToken();
            int n = Integer.valueOf(string5);
            String string6 = remoteClass.clearBreakpointLine(n);
            if (string6.length() > 0) {
                this.out.println(string6);
            } else {
                this.out.println("Breakpoint cleared at " + remoteClass.getName() + ": " + n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("Usage: clear <class>:<line_number>");
            this.out.println("   or: clear <class>.<method>[(argument_type,...)]");
        }
        catch (NumberFormatException numberFormatException) {
            this.out.println("Usage: clear <class>:<line_number>");
            this.out.println("   or: clear <class>.<method>[(argument_type,...)]");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
        }
    }

    void list(StringTokenizer stringTokenizer) throws Exception {
        int n;
        RemoteStackFrame remoteStackFrame = null;
        if (this.currentThread == null) {
            this.out.println("No thread specified.");
            return;
        }
        try {
            remoteStackFrame = this.currentThread.getCurrentFrame();
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread isn't suspended.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("Thread is not running (no stack).");
            return;
        }
        if (remoteStackFrame.getPC() == -1) {
            this.out.println("Current method is native");
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n = remoteStackFrame.getRemoteClass().getMethodLineNumber(string);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.out.println(string + " is not a valid line number or " + "method name for class " + remoteStackFrame.getRemoteClass().getName());
                    return;
                }
                catch (NoSuchLineNumberException noSuchLineNumberException) {
                    this.out.println("Line number information not found in " + remoteStackFrame.getRemoteClass().getName());
                    return;
                }
            }
        } else {
            n = remoteStackFrame.getLineNumber();
        }
        int n2 = n > 4 ? n - 4 : 1;
        int n3 = n2 + 9;
        InputStream inputStream = remoteStackFrame.getRemoteClass().getSourceFile();
        if (inputStream == null) {
            this.out.println("Unable to find " + remoteStackFrame.getRemoteClass().getSourceFileName());
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = null;
        int n4 = 1;
        while (n4 <= n2) {
            string = dataInputStream.readLine();
            ++n4;
        }
        if (string == null) {
            this.out.println(new Integer(n).toString() + " is an invalid line number for the file " + remoteStackFrame.getRemoteClass().getSourceFileName());
        }
        int n5 = n2;
        while (n5 < n3 && string != null) {
            this.out.print(new Integer(n5).toString() + "\t" + (n5 == n ? "=> " : "   "));
            this.out.println(string);
            string = dataInputStream.readLine();
            ++n5;
        }
    }

    void use(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(this.debugger.getSourcePath());
        } else {
            this.debugger.setSourcePath(stringTokenizer.nextToken());
        }
    }

    private void printVar(RemoteStackVariable remoteStackVariable) {
        this.out.print("  " + remoteStackVariable.getName());
        if (remoteStackVariable.inScope()) {
            RemoteValue remoteValue = remoteStackVariable.getValue();
            this.out.println(" = " + (remoteValue == null ? "null" : remoteValue.toString()));
        } else {
            this.out.println(" is not in scope");
        }
    }

    void locals() throws Exception {
        if (this.currentThread == null) {
            this.out.println("No default thread specified: use the \"thread\" command first.");
            return;
        }
        if (!this.currentThread.isSuspended()) {
            this.out.println("Thread isn't suspended.");
            return;
        }
        RemoteStackVariable[] remoteStackVariableArray = this.currentThread.getStackVariables();
        if (remoteStackVariableArray == null || remoteStackVariableArray.length == 0) {
            this.out.println("No local variables: try compiling with -g");
            return;
        }
        this.out.println("Method arguments:");
        int n = 0;
        while (n < remoteStackVariableArray.length) {
            if (remoteStackVariableArray[n].methodArgument()) {
                this.printVar(remoteStackVariableArray[n]);
            }
            ++n;
        }
        this.out.println("Local variables:");
        int n2 = 0;
        while (n2 < remoteStackVariableArray.length) {
            if (!remoteStackVariableArray[n2].methodArgument()) {
                this.printVar(remoteStackVariableArray[n2]);
            }
            ++n2;
        }
    }

    void print(StringTokenizer stringTokenizer, boolean bl) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No objects specified.");
            return;
        }
        RemoteValue remoteValue = null;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            int n;
            String string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, printDelimiters, true);
            String string2 = stringTokenizer2.nextToken();
            if (string2.startsWith("t@")) {
                this.setDefaultThreadGroup();
                RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
                try {
                    n = Integer.valueOf(string2.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n <= 0 || n > remoteThreadArray.length) {
                    this.out.println("\"" + string2 + "\" is not a valid thread id.");
                    continue;
                }
                remoteValue = remoteThreadArray[n - 1];
            } else if (string2.startsWith("$s")) {
                int n2;
                try {
                    n2 = Integer.valueOf(string2.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    this.out.println("\"" + string2 + "\" is not a valid slot.");
                    continue;
                }
                if (this.currentThread != null) {
                    object = this.currentThread.getStackVariables();
                    if (object == null || n2 >= ((RemoteStackVariable[])object).length) {
                        this.out.println("\"" + string2 + "\" is not a valid slot.");
                        continue;
                    }
                    remoteValue = object[n2].getValue();
                }
            } else if (string2.startsWith("0x") || Character.isDigit(string2.charAt(0))) {
                try {
                    n = RemoteValue.fromHex(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n == 0 || (remoteValue = this.debugger.get(new Integer(n))) == null) {
                    this.out.println("\"" + string2 + "\" is not a valid id.");
                    continue;
                }
            } else {
                RemoteStackVariable remoteStackVariable = null;
                if (this.currentThread != null) {
                    remoteStackVariable = this.currentThread.getStackVariable(string2);
                    if (remoteStackVariable != null && !remoteStackVariable.inScope()) {
                        this.out.println(string2 + " is not in scope.");
                        continue;
                    }
                    RemoteValue remoteValue2 = remoteValue = remoteStackVariable == null ? null : remoteStackVariable.getValue();
                }
                if (remoteStackVariable == null) {
                    String string3;
                    object = null;
                    String string4 = string2;
                    try {
                        string4 = string4 + stringTokenizer2.nextToken("");
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    if (this.currentThread != null) {
                        remoteStackVariable = this.currentThread.getStackVariable("this");
                    }
                    if (remoteStackVariable != null && remoteStackVariable.inScope()) {
                        remoteValue = remoteStackVariable.getValue();
                        object = this.printModifiers(string, new StringTokenizer("." + string4, printDelimiters, true), bl, remoteValue, true);
                        if (object == null) continue;
                    }
                    stringTokenizer2 = new StringTokenizer(string4, printDelimiters, true);
                    string2 = stringTokenizer2.nextToken();
                    while ((remoteValue = this.debugger.findClass(string2)) == null && stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer2.nextToken()).equals(".") && stringTokenizer2.hasMoreTokens()) {
                        string2 = string2 + string3 + stringTokenizer2.nextToken();
                    }
                    if (remoteValue == null) {
                        if (object == null) {
                            object = "\"" + string + "\" is not a " + "valid local or class name.";
                        }
                    } else {
                        string3 = this.printModifiers(string, stringTokenizer2, bl, remoteValue, false);
                        if (string3 == null) continue;
                        if (object == null) {
                            object = string3;
                        }
                    }
                    this.out.println((String)object);
                    continue;
                }
            }
            String string5 = this.printModifiers(string, stringTokenizer2, bl, remoteValue, false);
            if (string5 == null) continue;
            this.out.println(string5);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String printModifiers(String string, StringTokenizer stringTokenizer, boolean bl, RemoteValue remoteValue, boolean bl2) throws Exception {
        RemoteInt remoteInt = new RemoteInt(-1);
        RemoteValue remoteValue2 = remoteInt;
        if (remoteValue == null) {
            remoteValue2 = null;
        } else if (!remoteValue.isObject()) {
            remoteValue2 = remoteValue;
        }
        String string2 = "";
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        while (string3 != null) {
            int n;
            if (string3.equals(".")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return "\"" + string + "\" is not a valid expression.";
                }
                string3 = stringTokenizer.nextToken();
                if (remoteValue2 != remoteInt) {
                    return "\"" + string2 + "\" is not an object.";
                }
                string2 = string3;
                if (remoteValue instanceof RemoteArray) {
                    if (!string3.equals("length")) return "\"" + string3 + "\" is not a valid array field";
                    n = ((RemoteArray)remoteValue).getSize();
                    remoteValue2 = new RemoteInt(n);
                } else {
                    RemoteField[] remoteFieldArray = ((RemoteObject)remoteValue).getFields();
                    boolean bl3 = false;
                    int n2 = remoteFieldArray.length - 1;
                    while (n2 >= 0) {
                        if (string3.equals(remoteFieldArray[n2].getName())) {
                            remoteValue2 = ((RemoteObject)remoteValue).getFieldValue(n2);
                            bl3 = true;
                            break;
                        }
                        --n2;
                    }
                    if (!bl3) {
                        if (!bl2) return "\"" + string3 + "\" is not a valid field of " + remoteValue.description();
                        return "\"" + string + "\" is not a valid local, class name, or field of " + remoteValue.description();
                    }
                }
                bl2 = false;
                if (remoteValue2 != null && remoteValue2.isObject()) {
                    remoteValue = remoteValue2;
                    remoteValue2 = remoteInt;
                }
                string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                continue;
            }
            if (string3.equals("[")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return "\"" + string + "\" is not a valid expression.";
                }
                string3 = stringTokenizer.nextToken("]");
                try {
                    n = Integer.valueOf(string3);
                    remoteValue2 = ((RemoteArray)remoteValue).getElement(n);
                }
                catch (NumberFormatException numberFormatException) {
                    return "\"" + string3 + "\" is not a valid decimal number.";
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return string3 + " is out of bounds for " + remoteValue.description();
                }
                if (remoteValue2 != null && remoteValue2.isObject()) {
                    remoteValue = remoteValue2;
                    remoteValue2 = remoteInt;
                }
                if (!stringTokenizer.hasMoreTokens() || !(string3 = stringTokenizer.nextToken()).equals("]")) {
                    return "\"" + string + "\" is not a valid expression.";
                }
                string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken(printDelimiters) : null;
                continue;
            }
            if (!string3.equals("(")) return "invalid expression";
            return "print <method> not supported yet.";
        }
        this.out.print(string + " = ");
        if (remoteValue2 != remoteInt) {
            this.out.println(remoteValue2 == null ? "null" : remoteValue2.description());
            return null;
        } else if (bl && remoteValue instanceof RemoteObject) {
            RemoteClass[] remoteClassArray;
            this.out.println(remoteValue.description() + " {");
            if (remoteValue instanceof RemoteClass) {
                RemoteClass remoteClass = (RemoteClass)remoteValue;
                this.out.print("    superclass = ");
                RemoteClass remoteClass2 = remoteClass.getSuperclass();
                this.out.println(remoteClass2 == null ? "null" : remoteClass2.description());
                this.out.print("    loader = ");
                RemoteObject remoteObject = remoteClass.getClassLoader();
                this.out.println(remoteObject == null ? "null" : remoteObject.description());
                remoteClassArray = remoteClass.getInterfaces();
                if (remoteClassArray != null && remoteClassArray.length > 0) {
                    this.out.println("    interfaces:");
                    int n = 0;
                    while (n < remoteClassArray.length) {
                        this.out.println("        " + remoteClassArray[n]);
                        ++n;
                    }
                }
            }
            RemoteField[] remoteFieldArray = ((RemoteObject)remoteValue).getFields();
            if (remoteValue instanceof RemoteClass && remoteFieldArray.length > 0) {
                this.out.println();
            }
            int n = 0;
            while (n < remoteFieldArray.length) {
                String string4 = remoteFieldArray[n].getTypedName();
                remoteClassArray = remoteFieldArray[n].getModifiers();
                this.out.print("    " + (String)remoteClassArray + string4 + " = ");
                RemoteValue remoteValue3 = ((RemoteObject)remoteValue).getFieldValue(n);
                this.out.println(remoteValue3 == null ? "null" : remoteValue3.description());
                ++n;
            }
            this.out.println("}");
            return null;
        } else {
            this.out.println(remoteValue.toString());
        }
        return null;
    }

    void help() {
        this.out.println("** command list **");
        this.out.println("threads [threadgroup]     -- list threads");
        this.out.println("thread <thread id>        -- set default thread");
        this.out.println("suspend [thread id(s)]    -- suspend threads (default: all)");
        this.out.println("resume [thread id(s)]     -- resume threads (default: all)");
        this.out.println("where [thread id] | all   -- dump a thread's stack");
        this.out.println("wherei [thread id] | all  -- dump a thread's stack, with pc info");
        this.out.println("threadgroups              -- list threadgroups");
        this.out.println("threadgroup <name>        -- set current threadgroup\n");
        this.out.println("print <id> [id(s)]        -- print object or field");
        this.out.println("dump <id> [id(s)]         -- print all object information\n");
        this.out.println("locals                    -- print all local variables in current stack frame\n");
        this.out.println("classes                   -- list currently known classes");
        this.out.println("methods <class id>        -- list a class's methods\n");
        this.out.println("stop in <class id>.<method>[(argument_type,...)] -- set a breakpoint in a method");
        this.out.println("stop at <class id>:<line> -- set a breakpoint at a line");
        this.out.println("up [n frames]             -- move up a thread's stack");
        this.out.println("down [n frames]           -- move down a thread's stack");
        this.out.println("clear <class id>.<method>[(argument_type,...)]   -- clear a breakpoint in a method");
        this.out.println("clear <class id>:<line>   -- clear a breakpoint at a line");
        this.out.println("step                      -- execute current line");
        this.out.println("step up                   -- execute until the current method returns to its caller");
        this.out.println("stepi                     -- execute current instruction");
        this.out.println("next                      -- step one line (step OVER calls)");
        this.out.println("cont                      -- continue execution from breakpoint\n");
        this.out.println("catch <class id>          -- break for the specified exception");
        this.out.println("ignore <class id>         -- ignore when the specified exception\n");
        this.out.println("list [line number|method] -- print source code");
        this.out.println("use [source file path]    -- display or change the source path\n");
        this.out.println("memory                    -- report memory usage");
        this.out.println("gc                        -- free unused objects\n");
        this.out.println("load classname            -- load Java class to be debugged");
        this.out.println("run <class> [args]        -- start execution of a loaded Java class");
        this.out.println("!!                        -- repeat last command");
        this.out.println("help (or ?)               -- list commands");
        this.out.println("exit (or quit)            -- exit debugger");
    }

    void executeCommand(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().toLowerCase();
        try {
            if (string.equals("print")) {
                this.print(stringTokenizer, false);
            } else if (string.equals("dump")) {
                this.print(stringTokenizer, true);
            } else if (string.equals("locals")) {
                this.locals();
            } else if (string.equals("classes")) {
                this.classes();
            } else if (string.equals("methods")) {
                this.methods(stringTokenizer);
            } else if (string.equals("threads")) {
                this.threads(stringTokenizer);
            } else if (string.equals("thread")) {
                this.thread(stringTokenizer);
            } else if (string.equals("suspend")) {
                this.suspend(stringTokenizer);
            } else if (string.equals("resume")) {
                this.resume(stringTokenizer);
            } else if (string.equals("threadgroups")) {
                this.threadGroups();
            } else if (string.equals("threadgroup")) {
                this.threadGroup(stringTokenizer);
            } else if (string.equals("catch")) {
                this.catchException(stringTokenizer);
            } else if (string.equals("ignore")) {
                this.ignoreException(stringTokenizer);
            } else if (string.equals("cont")) {
                this.cont();
            } else if (string.equals("step")) {
                this.step(stringTokenizer);
            } else if (string.equals("stepi")) {
                this.stepi();
            } else if (string.equals("next")) {
                this.next();
            } else if (string.equals("kill")) {
                this.kill(stringTokenizer);
            } else if (string.equals("where")) {
                this.where(stringTokenizer, false);
            } else if (string.equals("wherei")) {
                this.where(stringTokenizer, true);
            } else if (string.equals("up")) {
                this.up(stringTokenizer);
            } else if (string.equals("down")) {
                this.down(stringTokenizer);
            } else if (string.equals("load")) {
                this.load(stringTokenizer);
            } else if (string.equals("run")) {
                this.run(stringTokenizer);
            } else if (string.equals("memory")) {
                this.memory();
            } else if (string.equals("gc")) {
                this.gc();
            } else if (string.equals("stop")) {
                this.stop(stringTokenizer);
            } else if (string.equals("clear")) {
                this.clear(stringTokenizer);
            } else if (string.equals("list")) {
                this.list(stringTokenizer);
            } else if (string.equals("use")) {
                this.use(stringTokenizer);
            } else if (string.equals("help") || string.equals("?")) {
                this.help();
            } else if (string.equals("quit") || string.equals("exit")) {
                this.debugger.close();
                System.exit(0);
            } else {
                this.out.println("huh? Try help...");
            }
        }
        catch (Exception exception) {
            this.out.println("Internal exception:");
            this.out.flush();
            exception.printStackTrace();
        }
    }

    void readCommandFile(File file) {
        try {
            if (file.canRead()) {
                String string;
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                while ((string = dataInputStream.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.executeCommand(stringTokenizer);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TTY(String string, String string2, String string3, String string4, PrintStream printStream, PrintStream printStream2, boolean bl) throws Exception {
        Object object;
        System.out.println("Initializing oldjdb...");
        this.out = printStream;
        this.console = printStream2;
        this.debugger = string2 == null ? new RemoteDebugger(string3, this, bl) : new RemoteDebugger(string, string2, this, bl);
        DataInputStream dataInputStream = new DataInputStream(System.in);
        String string5 = null;
        if (string4 != null && string4.length() > 0) {
            object = new StringTokenizer(string4);
            this.load((StringTokenizer)object);
            this.lastArgs = string4;
        }
        Thread.currentThread().setPriority(5);
        object = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "jdb.ini");
        if (!((File)object).canRead()) {
            object = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jdbrc");
        }
        this.readCommandFile((File)object);
        object = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "startup.jdb");
        this.readCommandFile((File)object);
        while (true) {
            StringTokenizer stringTokenizer;
            this.printPrompt();
            String string6 = dataInputStream.readLine();
            if (string6 == null) {
                this.out.println("Input stream closed.");
                return;
            }
            if (string6.startsWith("!!") && string5 != null) {
                string6 = string5 + string6.substring(2);
                this.out.println(string6);
            }
            if (!(stringTokenizer = new StringTokenizer(string6)).hasMoreTokens()) continue;
            string5 = string6;
            this.executeCommand(stringTokenizer);
        }
    }

    private static void usage() {
        String string = System.getProperty("path.separator");
        System.out.println("Usage: oldjdb <options> <class> <arguments>");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -help             print out this message and exit");
        System.out.println("    -version          print out the build version and exit");
        System.out.println("    -host <hostname>  host machine of interpreter to attach to");
        System.out.println("    -password <psswd> password of interpreter to attach to (from -debug)");
        System.out.println("    -dbgtrace         print info for debugging oldjdb");
        System.out.println();
        System.out.println("options forwarded to debuggee process:");
        System.out.println("    -D<name>=<value>  set a system property");
        System.out.println("    -classpath <directories separated by \"" + string + "\">");
        System.out.println("                      list directories in which to look for classes");
        System.out.println("    -X<option>        non-standard debuggee VM option");
        System.out.println();
        System.out.println("<class> is the name of the class to begin debugging");
        System.out.println("<arguments> are the arguments passed to the main() method of <class>");
        System.out.println();
        System.out.println("For command help type 'help' at oldjdb prompt");
    }

    public static void main(String[] stringArray) {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            string = "localhost";
        }
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string6 = stringArray[n];
            if (string6.equals("-dbgtrace")) {
                bl = true;
            } else if (string6.equals("-X")) {
                System.out.println("Use 'java -X' to see the available non-standard options");
                System.out.println();
                TTY.usage();
                System.exit(1);
            } else if (string6.startsWith("-D") || string6.startsWith("-X") || string6.equals("-noasyncgc") || string6.equals("-prof") || string6.equals("-verify") || string6.equals("-noverify") || string6.equals("-verifyremote") || string6.startsWith("-ms") || string6.startsWith("-mx") || string6.startsWith("-ss") || string6.startsWith("-oss")) {
                string5 = string5 + string6 + " ";
            } else if (string6.equals("-classpath")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No classpath specified.");
                    TTY.usage();
                    System.exit(1);
                }
                string5 = string5 + string6 + " " + stringArray[++n] + " ";
            } else if (string6.equals("-host")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No host specified.");
                    TTY.usage();
                    System.exit(1);
                }
                string2 = stringArray[++n];
            } else if (string6.equals("-password")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No password specified.");
                    TTY.usage();
                    System.exit(1);
                }
                string3 = stringArray[++n];
            } else if (string6.equals("-help")) {
                TTY.usage();
                System.exit(0);
            } else if (string6.equals("-version")) {
                System.out.println("oldjdb version 00/02/02");
                System.exit(0);
            } else {
                if (!string6.startsWith("-")) {
                    string4 = string6 + " ";
                    ++n;
                    while (n < stringArray.length) {
                        string4 = string4 + stringArray[n] + " ";
                        ++n;
                    }
                    break;
                }
                System.out.println("invalid option: " + string6);
                TTY.usage();
                System.exit(1);
            }
            ++n;
        }
        if (string2 != null && string3 == null) {
            System.out.println("A debug password must be specified for remote debugging.");
            System.exit(1);
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            if (!string2.equals(string) && string3.length() == 0) {
                System.out.println("No password supplied for accessing remote Java interpreter.");
                System.out.println("The password is reported by the remote interpreterwhen it is started.");
                System.exit(1);
            }
            new TTY(string2, string3, string5, string4, System.out, System.out, bl);
        }
        catch (SocketException socketException) {
            System.out.println("Failed accessing debugging session on " + string2 + ": invalid password.");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Failed accessing debugging session on " + string2 + ": invalid password.");
        }
        catch (Exception exception) {
            System.out.print("Internal exception:  ");
            System.out.flush();
            exception.printStackTrace();
        }
    }
}

