/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.omg.CosNaming.NameComponent;

public final class CNNameParser
implements NameParser {
    private static final Properties mySyntax = new Properties();
    private static final char kindSeparator = '.';
    private static final char compSeparator = '/';
    private static final char escapeChar = '\\';

    public Name parse(String string) throws NamingException {
        Vector vector = CNNameParser.insStringToStringifiedComps(string);
        return new CNCompoundName(vector.elements());
    }

    static NameComponent[] nameToCosName(Name name) throws InvalidNameException {
        int n = name.size();
        if (n == 0) {
            return new NameComponent[0];
        }
        NameComponent[] nameComponentArray = new NameComponent[n];
        int n2 = 0;
        while (n2 < n) {
            nameComponentArray[n2] = CNNameParser.parseComponent(name.get(n2));
            ++n2;
        }
        return nameComponentArray;
    }

    static String cosNameToInsString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nameComponentArray.length) {
            if (n > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(CNNameParser.stringifyComponent(nameComponentArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    static Name cosNameToName(NameComponent[] nameComponentArray) {
        CompositeName compositeName = new CompositeName();
        int n = 0;
        while (nameComponentArray != null && n < nameComponentArray.length) {
            try {
                compositeName.add(CNNameParser.stringifyComponent(nameComponentArray[n]));
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
            ++n;
        }
        return compositeName;
    }

    private static Vector insStringToStringifiedComps(String string) throws InvalidNameException {
        int n = string.length();
        Vector vector = new Vector(10);
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            int n4 = 0;
            boolean bl = true;
            while (n2 < n) {
                if (string.charAt(n2) == '/') break;
                if (string.charAt(n2) == '\\') {
                    if (n2 + 1 >= n) {
                        throw new InvalidNameException(string + ": unescaped \\ at end of component");
                    }
                    if (CNNameParser.isMeta(string.charAt(n2 + 1))) {
                        ++n2;
                        if (bl) {
                            cArray[n4++] = string.charAt(n2++);
                            continue;
                        }
                        cArray2[n3++] = string.charAt(n2++);
                        continue;
                    }
                    throw new InvalidNameException(string + ": invalid character being escaped");
                }
                if (bl && string.charAt(n2) == '.') {
                    ++n2;
                    bl = false;
                    continue;
                }
                if (bl) {
                    cArray[n4++] = string.charAt(n2++);
                    continue;
                }
                cArray2[n3++] = string.charAt(n2++);
            }
            vector.addElement(CNNameParser.stringifyComponent(new NameComponent(new String(cArray, 0, n4), new String(cArray2, 0, n3))));
            if (n2 >= n) continue;
            ++n2;
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NameComponent parseComponent(String string) throws InvalidNameException {
        NameComponent nameComponent = new NameComponent();
        int n = -1;
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2];
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2 && n < 0) {
            if (bl) {
                cArray[n3++] = string.charAt(n4);
                bl = false;
            } else if (string.charAt(n4) == '\\') {
                if (n4 + 1 >= n2) {
                    throw new InvalidNameException(string + ": unescaped \\ at end of component");
                }
                if (!CNNameParser.isMeta(string.charAt(n4 + 1))) throw new InvalidNameException(string + ": invalid character being escaped");
                bl = true;
            } else if (string.charAt(n4) == '.') {
                n = n4;
            } else {
                cArray[n3++] = string.charAt(n4);
            }
            ++n4;
        }
        nameComponent.id = new String(cArray, 0, n3);
        if (n < 0) {
            nameComponent.kind = "";
            return nameComponent;
        } else {
            n3 = 0;
            bl = false;
            int n5 = n + 1;
            while (n5 < n2) {
                if (bl) {
                    cArray[n3++] = string.charAt(n5);
                    bl = false;
                } else if (string.charAt(n5) == '\\') {
                    if (n5 + 1 >= n2) {
                        throw new InvalidNameException(string + ": unescaped \\ at end of component");
                    }
                    if (!CNNameParser.isMeta(string.charAt(n5 + 1))) throw new InvalidNameException(string + ": invalid character being escaped");
                    bl = true;
                } else {
                    cArray[n3++] = string.charAt(n5);
                }
                ++n5;
            }
            nameComponent.kind = new String(cArray, 0, n3);
        }
        return nameComponent;
    }

    private static String stringifyComponent(NameComponent nameComponent) {
        StringBuffer stringBuffer = new StringBuffer(CNNameParser.escape(nameComponent.id));
        if (nameComponent.kind != null && !nameComponent.kind.equals("")) {
            stringBuffer.append('.' + CNNameParser.escape(nameComponent.kind));
        }
        if (stringBuffer.length() == 0) {
            return ".";
        }
        return stringBuffer.toString();
    }

    private static String escape(String string) {
        if (string.indexOf(46) < 0 && string.indexOf(47) < 0 && string.indexOf(92) < 0) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n + n];
        int n3 = 0;
        while (n3 < n) {
            if (CNNameParser.isMeta(string.charAt(n3))) {
                cArray[n2++] = 92;
            }
            cArray[n2++] = string.charAt(n3);
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    private static boolean isMeta(char c) {
        switch (c) {
            case '.': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    static {
        mySyntax.put("jndi.syntax.direction", "left_to_right");
        mySyntax.put("jndi.syntax.separator", "/");
        mySyntax.put("jndi.syntax.escape", "\\");
    }

    static final class CNCompoundName
    extends CompoundName {
        CNCompoundName(Enumeration enumeration) {
            super(enumeration, mySyntax);
        }

        public Object clone() {
            return new CNCompoundName(this.getAll());
        }

        public Name getPrefix(int n) {
            Enumeration enumeration = super.getPrefix(n).getAll();
            return new CNCompoundName(enumeration);
        }

        public Name getSuffix(int n) {
            Enumeration enumeration = super.getSuffix(n).getAll();
            return new CNCompoundName(enumeration);
        }

        public String toString() {
            try {
                return CNNameParser.cosNameToInsString(CNNameParser.nameToCosName(this));
            }
            catch (InvalidNameException invalidNameException) {
                return super.toString();
            }
        }
    }
}

