/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.cosnaming.CNNameParser;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public final class ExceptionMapper {
    private static final boolean debug = false;

    private ExceptionMapper() {
    }

    public static final NamingException mapException(Exception exception, CNCtx cNCtx, NameComponent[] nameComponentArray) throws NamingException {
        NamingException namingException;
        if (exception instanceof NamingException) {
            return (NamingException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof NotFound) {
            if (cNCtx.federation) {
                return ExceptionMapper.tryFed((NotFound)exception, cNCtx, nameComponentArray);
            }
            namingException = new NameNotFoundException();
        } else if (exception instanceof CannotProceed) {
            NameComponent[] nameComponentArray2;
            namingException = new CannotProceedException();
            NamingContext namingContext = ((CannotProceed)exception).cxt;
            NameComponent[] nameComponentArray3 = ((CannotProceed)exception).rest_of_name;
            if (nameComponentArray == null) {
                nameComponentArray2 = new NameComponent[]{};
            } else {
                nameComponentArray2 = new NameComponent[nameComponentArray.length - nameComponentArray3.length];
                System.arraycopy(nameComponentArray, 0, nameComponentArray2, 0, nameComponentArray2.length);
            }
            namingException.setResolvedObj(new CNCtx(cNCtx._orb, namingContext, cNCtx._env, cNCtx.makeFullName(nameComponentArray2)));
            namingException.setRemainingName(CNNameParser.cosNameToName(nameComponentArray3));
        } else {
            namingException = exception instanceof InvalidName ? new InvalidNameException() : (exception instanceof AlreadyBound ? new NameAlreadyBoundException() : (exception instanceof NotEmpty ? new ContextNotEmptyException() : new NamingException("Unknown reasons")));
        }
        namingException.setRootCause(exception);
        return namingException;
    }

    private static final NamingException tryFed(NotFound notFound, CNCtx cNCtx, NameComponent[] nameComponentArray) throws NamingException {
        Object object;
        NameComponent[] nameComponentArray2;
        NameComponent[] nameComponentArray3 = notFound.rest_of_name;
        if (nameComponentArray == null) {
            nameComponentArray2 = new NameComponent[]{};
        } else {
            nameComponentArray2 = new NameComponent[nameComponentArray.length - nameComponentArray3.length];
            System.arraycopy(nameComponentArray, 0, nameComponentArray2, 0, nameComponentArray2.length);
        }
        CannotProceedException cannotProceedException = new CannotProceedException();
        cannotProceedException.setRootCause(notFound);
        cannotProceedException.setRemainingName(CNNameParser.cosNameToName(nameComponentArray3));
        cannotProceedException.setEnvironment(cNCtx._env);
        final Object object2 = cNCtx.callResolve(nameComponentArray2);
        if (object2 instanceof Context) {
            RefAddr refAddr = new RefAddr("nns"){

                public Object getContent() {
                    return object2;
                }
            };
            Reference reference = new Reference("java.lang.Object", refAddr);
            CompositeName compositeName = new CompositeName();
            compositeName.add("");
            cannotProceedException.setResolvedObj(reference);
            cannotProceedException.setAltName(compositeName);
            cannotProceedException.setAltNameCtx((Context)object2);
            return cannotProceedException;
        }
        Name name = CNNameParser.cosNameToName(nameComponentArray2);
        try {
            object = NamingManager.getObjectInstance(object2, name, cNCtx, cNCtx._env);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("problem generating object using object factory");
            namingException.setRootCause(exception);
            throw namingException;
        }
        if (object instanceof Context) {
            cannotProceedException.setResolvedObj(object);
        } else {
            name.add("");
            cannotProceedException.setAltName(name);
            final Object object3 = object;
            RefAddr refAddr = new RefAddr("nns"){

                public Object getContent() {
                    return object3;
                }
            };
            Reference reference = new Reference("java.lang.Object", refAddr);
            cannotProceedException.setResolvedObj(reference);
            cannotProceedException.setAltNameCtx(cNCtx);
        }
        return cannotProceedException;
    }
}

