/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.Printer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractDataLine
extends AbstractLine
implements DataLine {
    protected AudioFormat defaultFormat;
    protected int defaultBufferSize;
    protected AudioFormat format;
    protected int bufferSize;
    protected boolean running = false;
    private boolean started = false;
    private boolean active = false;
    private int position = 0;

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray, AudioFormat audioFormat, int n) {
        super(info, abstractMixer, controlArray);
        this.defaultFormat = audioFormat;
        this.defaultBufferSize = n;
        this.format = this.defaultFormat;
        this.bufferSize = this.defaultBufferSize;
    }

    public synchronized void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: open(format, bufferSize)");
        }
        if (!this.isOpen()) {
            this.mixer.open(this, audioFormat, n);
            try {
                this.implOpen(audioFormat, n);
                this.setOpen(true);
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.mixer.close(this);
                throw lineUnavailableException;
            }
        } else if (!audioFormat.matches(this.getFormat()) || n != -1 && n != this.getBufferSize()) {
            throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
        }
        if (Printer.trace) {
            Printer.trace("< AbstractDataLine: open(format, bufferSize) completed");
        }
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, -1);
    }

    public int available() {
        return 0;
    }

    public void drain() {
        if (Printer.trace) {
            Printer.trace("AbstractDataLine: drain");
        }
    }

    public void flush() {
        if (Printer.trace) {
            Printer.trace("AbstractDataLine: flush");
        }
    }

    public void start() {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: start()");
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.isOpen() && !this.isStartedRunning()) {
                if (this.mixer != this) {
                    this.mixer.start(this);
                }
                this.implStart();
                this.running = true;
            }
        }
        AbstractDataLine abstractDataLine2 = this;
        synchronized (abstractDataLine2) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("< AbstractDataLine: start() completed");
        }
    }

    public void stop() {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: stop()");
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.isOpen() && this.isStartedRunning()) {
                this.implStop();
                this.mixer.stop(this);
                this.running = false;
                if (this.started && !this.isActive()) {
                    this.setStarted(false);
                }
            }
        }
        AbstractDataLine abstractDataLine2 = this;
        synchronized (abstractDataLine2) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("< AbstractDataLine: stop() completed");
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getMicrosecondPosition() {
        long l = -1L;
        int n = this.getFramePosition();
        if (n != -1) {
            l = (long)((double)n * 1000000.0 / (double)this.getFormat().getFrameRate());
        }
        return l;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public float getLevel() {
        return -1.0f;
    }

    protected boolean isStartedRunning() {
        return this.running;
    }

    protected void setActive(boolean bl) {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setActive(" + bl + ")");
        }
        boolean bl2 = false;
        int n = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setActive: this.active: " + this.active);
            }
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setActive: active: " + bl);
            }
            if (this.active != bl) {
                this.active = bl;
                bl2 = true;
            }
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setActive: this.active: " + this.active);
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setActive: sendEvents: " + bl2);
        }
    }

    protected void setStarted(boolean bl) {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setStarted(" + bl + ")");
        }
        boolean bl2 = false;
        int n = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setStarted: this.started: " + this.started);
            }
            if (Printer.debug) {
                Printer.debug("    AbstractDataLine: setStarted: started: " + bl);
            }
            if (this.started != bl) {
                this.started = bl;
                bl2 = true;
            }
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setStarted: this.started: " + this.started);
        }
        if (Printer.debug) {
            Printer.debug("    AbstractDataLine: setStarted: sendEvents: " + bl2);
        }
        if (bl2) {
            if (bl) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.START, n));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, n));
            }
        }
    }

    protected void setEOM() {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setEOM()");
        }
        int n = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.started = false;
        }
        this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, n));
    }

    public synchronized void open() throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: open()");
        }
        this.open(this.format, this.bufferSize);
    }

    public synchronized void close() {
        if (this.isOpen()) {
            this.stop();
            this.setOpen(false);
            this.implClose();
            this.mixer.close(this);
            this.format = this.defaultFormat;
            this.bufferSize = this.defaultBufferSize;
        }
    }

    abstract void implOpen(AudioFormat var1, int var2) throws LineUnavailableException;

    abstract void implClose();

    abstract void implStart();

    abstract void implStop();
}

