/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractDataLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    protected Vector formats = new Vector();
    protected Vector sourceLines = new Vector();
    protected Vector targetLines = new Vector();

    protected AbstractMixer(DataLine.Info info, Control[] controlArray, AudioFormat audioFormat, int n, Mixer.Info info2, Line.Info[] infoArray, Line.Info[] infoArray2) {
        super(info, null, controlArray, audioFormat, n);
        this.mixer = this;
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.mixerInfo = info2;
        this.sourceLineInfo = infoArray;
        this.targetLineInfo = infoArray2;
    }

    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    public Line.Info[] getSourceLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, infoArray, 0, this.sourceLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, infoArray, 0, this.targetLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                vector.addElement(this.sourceLineInfo[n]);
            }
            ++n;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n = 0;
        while (n < infoArray.length) {
            infoArray[n] = (Line.Info)vector.elementAt(n);
            ++n;
        }
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n])) {
                vector.addElement(this.targetLineInfo[n]);
            }
            ++n;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n = 0;
        while (n < infoArray.length) {
            infoArray[n] = (Line.Info)vector.elementAt(n);
            ++n;
        }
        return infoArray;
    }

    public boolean isLineSupported(Line.Info info) {
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    public abstract int getMaxLines(Line.Info var1);

    public Line[] getSourceLines() {
        Line[] lineArray;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            lineArray = new Line[this.sourceLines.size()];
            int n = 0;
            while (n < lineArray.length) {
                lineArray[n] = (Line)this.sourceLines.elementAt(n);
                ++n;
            }
        }
        return lineArray;
    }

    public Line[] getTargetLines() {
        Line[] lineArray;
        Vector vector = this.targetLines;
        synchronized (vector) {
            lineArray = new Line[this.targetLines.size()];
            int n = 0;
            while (n < lineArray.length) {
                lineArray[n] = (Line)this.targetLines.elementAt(n);
                ++n;
            }
        }
        return lineArray;
    }

    public void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    public synchronized void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        AudioFormat audioFormat2;
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(format = " + audioFormat + "), bufferSize = " + n);
        }
        if ((audioFormat2 = AbstractMixer.getSystemFormat()) != null && !audioFormat.matches(audioFormat2)) {
            throw new LineUnavailableException("Requested format incompatible with already established device format: " + audioFormat2);
        }
        super.open(audioFormat, n);
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(format = " + audioFormat + "), bufferSize = " + n + " succeeded");
        }
    }

    public synchronized void open() throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open()");
        }
        try {
            this.open(this.format, this.bufferSize);
        }
        catch (LineUnavailableException lineUnavailableException) {
            AudioFormat audioFormat = null;
            audioFormat = AbstractMixer.getSystemFormat();
            if (audioFormat != null) {
                this.open(audioFormat, -1);
            }
            throw lineUnavailableException;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open() succeeded");
        }
    }

    protected void open(Line line) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open();
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo())) {
            if (!this.targetLines.contains(line)) {
                this.open();
                this.targetLines.addElement(line);
            }
        } else if (Printer.err) {
            Printer.err("Unknown line received for AbstractMixer.open(Line): " + line);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(" + line + ") completed");
        }
    }

    protected void open(DataLine dataLine, AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + dataLine + ")");
        }
        this.open(dataLine);
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(line, format, bufferSize) completed");
        }
    }

    protected void close(Line line) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: close(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (Printer.debug) {
            Printer.debug("AbstractMixer: close(line): sourceLines.size() now: " + this.sourceLines.size());
        }
        if (Printer.debug) {
            Printer.debug("AbstractMixer: close(line): targetLines.size() now: " + this.targetLines.size());
        }
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty()) {
            this.close();
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: close(" + line + ") succeeded");
        }
    }

    protected void start(Line line) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: start(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        if (!this.isStartedRunning()) {
            if (Printer.debug) {
                Printer.debug("AbstractMixer: start(line): starting the mixer");
            }
            this.start();
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: start(" + line + ") succeeded");
        }
    }

    protected void stop(Line line) {
        Object object;
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: stop(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        Vector vector = (Vector)this.sourceLines.clone();
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof AbstractDataLine && ((AbstractDataLine)(object = (AbstractDataLine)vector.elementAt(n))).isStartedRunning() && !object.equals(line)) {
                return;
            }
            ++n;
        }
        object = (Vector)this.targetLines.clone();
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            AbstractDataLine abstractDataLine = (AbstractDataLine)((Vector)object).elementAt(n2);
            if (abstractDataLine.isStartedRunning() && !abstractDataLine.equals(line)) {
                if (Printer.trace) {
                    Printer.trace("<< AbstractMixer: stop(" + line + ") found running targetLine: " + abstractDataLine);
                }
                return;
            }
            ++n2;
        }
        if (Printer.debug) {
            Printer.debug("AbstractMixer: stop(line): stopping the mixer");
        }
        this.stop();
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: stop(" + line + ") succeeded");
        }
    }

    boolean isSourceLine(Line.Info info) {
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        int n = 0;
        while (n < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    Line.Info getLineInfo(Line.Info info) {
        int n = 0;
        while (n < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n])) {
                return this.sourceLineInfo[n];
            }
            ++n;
        }
        n = 0;
        while (n < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n])) {
                return this.targetLineInfo[n];
            }
            ++n;
        }
        return null;
    }

    static AudioFormat getSystemFormat() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            if (mixer.isOpen() && mixer instanceof DataLine) {
                return ((DataLine)((Object)mixer)).getFormat();
            }
            ++n;
        }
        return null;
    }
}

