/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;

public class ProtectionDomain {
    private CodeSource codesource;
    private PermissionCollection permissions;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public boolean implies(Permission permission) {
        if (this.permissions != null) {
            return this.permissions.implies(permission);
        }
        return false;
    }

    public String toString() {
        return "ProtectionDomain " + this.codesource + "\n" + this.permissions + "\n";
    }
}

