/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class CompactByteArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private byte[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactByteArray() {
        this(0);
    }

    public CompactByteArray(byte by) {
        this.values = new byte[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int n = 0;
        while (n < 65536) {
            this.values[n] = by;
            ++n;
        }
        n = 0;
        while (n < 512) {
            this.indices[n] = (short)(n << 7);
            this.hashes[n] = 0;
            ++n;
        }
        this.isCompact = false;
    }

    public CompactByteArray(short[] sArray, byte[] byArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds!");
        }
        int n = 0;
        while (n < 512) {
            short s = sArray[n];
            if (s < 0 || s >= byArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds!");
            }
            ++n;
        }
        this.indices = sArray;
        this.values = byArray;
        this.isCompact = true;
    }

    public byte elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = by;
        this.touchBlock(c >> 7, by);
    }

    public void setElementAt(char n, char c, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        int n2 = n;
        while (n2 <= c) {
            this.values[n2] = by;
            this.touchBlock(n2 >> 7, by);
            ++n2;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = -1;
                n = this.blockTouched(n5) ? 1 : 0;
                if (n == 0 && n4 != -1) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && CompactByteArray.arrayRegionMatches(this.values, n3, this.values, n6, 128)) {
                            this.indices[n5] = (short)n6;
                            break;
                        }
                        ++n7;
                        n6 += 128;
                    }
                    if (this.indices[n5] == -1) {
                        System.arraycopy(this.values, n3, this.values, n6, 128);
                        this.indices[n5] = (short)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (n == 0) {
                            n4 = (short)n6;
                        }
                    }
                }
                ++n5;
                n3 += 128;
            }
            n = n2 * 128;
            byte[] byArray = new byte[n];
            System.arraycopy(this.values, 0, byArray, 0, n);
            this.values = byArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        int n6 = n;
        while (n6 < n4) {
            if (byArray[n6] != byArray2[n6 + n5]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public byte[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactByteArray compactByteArray = (CompactByteArray)super.clone();
            compactByteArray.values = (byte[])this.values.clone();
            compactByteArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactByteArray.hashes = (int[])this.hashes.clone();
            }
            return compactByteArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactByteArray compactByteArray = (CompactByteArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactByteArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    private void expand() {
        if (this.isCompact) {
            this.hashes = new int[512];
            byte[] byArray = new byte[65536];
            int n = 0;
            while (n < 65536) {
                byte by;
                byArray[n] = by = this.elementAt((char)n);
                this.touchBlock(n >> 7, by);
                ++n;
            }
            n = 0;
            while (n < 512) {
                this.indices[n] = (short)(n << 7);
                ++n;
            }
            this.values = null;
            this.values = byArray;
            this.isCompact = false;
        }
    }

    private byte[] getArray() {
        return this.values;
    }
}

