/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.security.util.ManifestEntryVerifier;

public class JarFile
extends ZipFile {
    private Manifest man;
    private JarEntry manEntry;
    private boolean manLoaded;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    public JarFile(String string) throws IOException {
        this(new File(string), true, 1);
    }

    public JarFile(String string, boolean bl) throws IOException {
        this(new File(string), bl, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean bl) throws IOException {
        this(file, bl, 1);
    }

    public JarFile(File file, boolean bl, int n) throws IOException {
        super(file, n);
        this.verify = bl;
    }

    public Manifest getManifest() throws IOException {
        if (!this.manLoaded) {
            Object[] objectArray;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (objectArray = this.getMetaInfEntryNames()) != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (MANIFEST_NAME.equals(objectArray[n].toUpperCase())) {
                        this.manEntry = this.getJarEntry(objectArray[n]);
                        break;
                    }
                    ++n;
                }
            }
            if (this.manEntry != null) {
                if (this.verify) {
                    objectArray = this.getBytes(this.manEntry);
                    this.man = new Manifest(new ByteArrayInputStream((byte[])objectArray));
                    this.jv = new JarVerifier(this.man, (byte[])objectArray);
                } else {
                    this.man = new Manifest(super.getInputStream(this.manEntry));
                }
            }
            this.manLoaded = true;
        }
        return this.man;
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                return new JarFileEntry(zipEntry);
            }
        };
    }

    private void initializeVerifier() {
        ManifestEntryVerifier manifestEntryVerifier = null;
        try {
            String[] stringArray = this.getMetaInfEntryNames();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    JarEntry jarEntry = this.getJarEntry(stringArray[n]);
                    if (!jarEntry.isDirectory()) {
                        byte[] byArray;
                        if (manifestEntryVerifier == null) {
                            manifestEntryVerifier = new ManifestEntryVerifier(this.man);
                        }
                        if ((byArray = this.getBytes(jarEntry)) != null && byArray.length > 0) {
                            this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                            this.jv.update(byArray.length, byArray, 0, byArray.length, manifestEntryVerifier);
                            this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                        }
                    }
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            this.jv = null;
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
            }
        }
    }

    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        DataInputStream dataInputStream = new DataInputStream(super.getInputStream(zipEntry));
        dataInputStream.readFully(byArray, 0, byArray.length);
        dataInputStream.close();
        return byArray;
    }

    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (!this.manLoaded) {
            this.getManifest();
        }
        if (this.jv == null) {
            return super.getInputStream(zipEntry);
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(zipEntry);
            }
        }
        return new JarVerifier.VerifierStream(this.man, (JarEntry)zipEntry, super.getInputStream(zipEntry), this.jv);
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = JarFile.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray;
            if (this.certs == null && JarFile.this.jv != null && (certificateArray = JarFile.this.jv.getCerts(this.getName())) != null) {
                this.certs = (Certificate[])certificateArray.clone();
            }
            return this.certs;
        }
    }
}

