/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;

public class ActivationGroupImpl
extends ActivationGroup {
    private static final long serialVersionUID = 5758693559430427303L;
    private Hashtable active = new Hashtable(101);
    private boolean groupInactive = false;
    private ActivationGroupID groupID;
    private ArrayList lockedIDs = new ArrayList();
    private static Class[] objConstrParams = new Class[]{class$java$rmi$activation$ActivationID == null ? (class$java$rmi$activation$ActivationID = ActivationGroupImpl.class$("java.rmi.activation.ActivationID")) : class$java$rmi$activation$ActivationID, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = ActivationGroupImpl.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject};
    static /* synthetic */ Class class$java$rmi$activation$ActivationID;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;

    public ActivationGroupImpl(ActivationGroupID activationGroupID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationGroupID);
        this.groupID = activationGroupID;
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (Exception exception) {
                throw new RemoteException("unable to set security manager", exception);
            }
        }
    }

    private void acquireLock(ActivationID activationID) {
        while (true) {
            ActivationID activationID2;
            ArrayList arrayList = this.lockedIDs;
            synchronized (arrayList) {
                int n = this.lockedIDs.indexOf(activationID);
                if (n <= 0) {
                    this.lockedIDs.add(activationID);
                    return;
                }
                activationID2 = (ActivationID)this.lockedIDs.get(n);
            }
            ActivationID activationID3 = activationID2;
            synchronized (activationID3) {
                ArrayList arrayList2 = this.lockedIDs;
                synchronized (arrayList2) {
                    int n = this.lockedIDs.indexOf(activationID2);
                    if (n < 0) {
                        continue;
                    }
                    ActivationID activationID4 = (ActivationID)this.lockedIDs.get(n);
                    if (activationID4 != activationID2) {
                        continue;
                    }
                }
                try {
                    activationID2.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void releaseLock(ActivationID activationID) {
        ArrayList arrayList = this.lockedIDs;
        synchronized (arrayList) {
            this.lockedIDs.remove(activationID);
        }
        ActivationID activationID2 = activationID;
        synchronized (activationID2) {
            activationID.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarshalledObject newInstance(final ActivationID activationID, final ActivationDesc activationDesc) throws ActivationException {
        MarshalledObject marshalledObject;
        if (!this.groupID.equals(activationDesc.getGroupID())) {
            throw new ActivationException("newInstance in wrong group");
        }
        try {
            try {
                Remote remote;
                ActiveEntry activeEntry;
                block19: {
                    this.acquireLock(activationID);
                    ActivationGroupImpl activationGroupImpl = this;
                    synchronized (activationGroupImpl) {
                        if (this.groupInactive) {
                            throw new ActivationException("group is inactive");
                        }
                    }
                    activeEntry = (ActiveEntry)this.active.get(activationID);
                    if (activeEntry != null) {
                        MarshalledObject marshalledObject2 = activeEntry.mobj;
                        Object var12_9 = null;
                        this.releaseLock(activationID);
                        this.checkInactiveGroup();
                        return marshalledObject2;
                    }
                    String string = activationDesc.getClassName();
                    final Class clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string);
                    remote = null;
                    try {
                        remote = (Remote)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                                Constructor constructor = clazz.getDeclaredConstructor(objConstrParams);
                                constructor.setAccessible(true);
                                Object[] objectArray = new Object[]{activationID, activationDesc.getData()};
                                return (Remote)constructor.newInstance(objectArray);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstantiationException) {
                            throw (InstantiationException)exception;
                        }
                        if (exception instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)exception;
                        }
                        if (exception instanceof IllegalAccessException) {
                            throw (IllegalAccessException)exception;
                        }
                        if (exception instanceof InvocationTargetException) {
                            throw (InvocationTargetException)exception;
                        }
                        if (exception instanceof RuntimeException) {
                            throw (RuntimeException)exception;
                        }
                        if (!(exception instanceof Error)) break block19;
                        throw (Error)((Object)exception);
                    }
                }
                activeEntry = new ActiveEntry(remote);
                this.active.put(activationID, activeEntry);
                marshalledObject = activeEntry.mobj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodError);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ActivationException("exception in object constructor", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new ActivationException("unable to activate object", exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var12_10 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return marshalledObject;
    }

    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            ActivationGroupImpl activationGroupImpl = this;
            synchronized (activationGroupImpl) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            ActiveEntry activeEntry = (ActiveEntry)this.active.get(activationID);
            if (activeEntry == null) {
                throw new UnknownObjectException("object not active");
            }
            try {
                if (!Activatable.unexportObject(activeEntry.impl, false)) {
                    boolean bl = false;
                    Object var6_8 = null;
                    this.releaseLock(activationID);
                    this.checkInactiveGroup();
                    return bl;
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            try {
                super.inactiveObject(activationID);
            }
            catch (UnknownObjectException unknownObjectException) {
                // empty catch block
            }
            this.active.remove(activationID);
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var6_9 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return true;
    }

    private void checkInactiveGroup() {
        boolean bl = false;
        ActivationGroupImpl activationGroupImpl = this;
        synchronized (activationGroupImpl) {
            if (this.active.size() == 0 && this.lockedIDs.size() == 0 && !this.groupInactive) {
                this.groupInactive = true;
                bl = true;
            }
        }
        if (bl) {
            try {
                super.inactiveGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    public void activeObject(ActivationID activationID, Remote remote) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            ActivationGroupImpl activationGroupImpl = this;
            synchronized (activationGroupImpl) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            if (!this.active.contains(activationID)) {
                ActiveEntry activeEntry = new ActiveEntry(remote);
                this.active.put(activationID, activeEntry);
                super.activeObject(activationID, activeEntry.mobj);
            }
            Object var6_6 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject mobj;

        ActiveEntry(Remote remote) throws ActivationException {
            this.impl = remote;
            try {
                this.mobj = new MarshalledObject(remote);
            }
            catch (IOException iOException) {
                throw new ActivationException("failed to marshal remote object", iOException);
            }
        }
    }
}

